/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.notification.NotificationContext;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class WorkflowNotificationUtils {
    public static final String PROP_SEND_EMAIL_NOTIFICATIONS = "bpm_sendEMailNotifications";
    public static final String PROP_PACKAGE = "bpm_package";
    public static final String MSG_ASSIGNED_TASK = "assigned-task";
    public static final String MSG_NEW_POOLED_TASK = "new-pooled-task";
    public static final String ARG_WF_ID = "workflowId";
    public static final String ARG_WF_TITLE = "workflowTitle";
    public static final String ARG_WF_DESCRIPTION = "workflowDescription";
    public static final String ARG_WF_DUEDATE = "workflowDueDate";
    public static final String ARG_WF_PRIORITY = "workflowPriority";
    public static final String ARG_WF_POOLED = "workflowPooled";
    public static final String ARG_WF_DOCUMENTS = "workflowDocuments";
    public static final NodeRef WF_ASSIGNED_TEMPLATE = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "wf-email-html-ftl");

    public static void sendWorkflowAssignedNotificationEMail(ServiceRegistry services, String taskId, String title, String description, Date dueDate, Integer priority, NodeRef workflowPackage, String[] assignedAuthorites, boolean pooled) {
        NotificationContext notificationContext = new NotificationContext();
        String subject = null;
        subject = !pooled ? I18NUtil.getMessage((String)MSG_ASSIGNED_TASK) : I18NUtil.getMessage((String)MSG_NEW_POOLED_TASK);
        notificationContext.setSubject(subject);
        notificationContext.setBodyTemplate(WF_ASSIGNED_TEMPLATE);
        HashMap<String, Serializable> templateArgs = new HashMap<String, Serializable>(7);
        templateArgs.put(ARG_WF_ID, (Serializable)((Object)taskId));
        templateArgs.put(ARG_WF_TITLE, (Serializable)((Object)title));
        templateArgs.put(ARG_WF_DESCRIPTION, (Serializable)((Object)description));
        if (dueDate != null) {
            templateArgs.put(ARG_WF_DUEDATE, dueDate);
        }
        if (priority != null) {
            templateArgs.put(ARG_WF_PRIORITY, priority);
        }
        templateArgs.put(ARG_WF_POOLED, Boolean.valueOf(pooled));
        if (workflowPackage != null) {
            List assocs = services.getNodeService().getChildAssocs(workflowPackage);
            NodeRef[] docs = new NodeRef[assocs.size()];
            if (assocs.size() != 0) {
                int index = 0;
                for (ChildAssociationRef assoc : assocs) {
                    docs[index] = assoc.getChildRef();
                    ++index;
                }
                templateArgs.put(ARG_WF_DOCUMENTS, (Serializable)docs);
            }
        }
        notificationContext.setTemplateArgs(templateArgs);
        for (String assignedAuthority : assignedAuthorites) {
            notificationContext.addTo(assignedAuthority);
        }
        notificationContext.setAsyncNotification(true);
        services.getNotificationService().sendNotification("email", notificationContext);
    }

    public static void sendWorkflowAssignedNotificationEMail(ServiceRegistry services, String taskId, String[] assignedAuthorites, boolean pooled) {
        WorkflowTask workflowTask = services.getWorkflowService().getTaskById(taskId);
        Map<QName, Serializable> props = workflowTask.getProperties();
        String title = workflowTask.getTitle();
        String description = (String)((Object)props.get(WorkflowModel.PROP_DESCRIPTION));
        Date dueDate = (Date)props.get(WorkflowModel.PROP_DUE_DATE);
        Integer priority = (Integer)props.get(WorkflowModel.PROP_PRIORITY);
        NodeRef workflowPackage = workflowTask.getPath().getInstance().getWorkflowPackage();
        WorkflowNotificationUtils.sendWorkflowAssignedNotificationEMail(services, taskId, title, description, dueDate, priority, workflowPackage, assignedAuthorites, pooled);
    }

    public static void sendWorkflowAssignedNotificationEMail(ServiceRegistry services, String taskId, String assignedAuthority, boolean pooled) {
        WorkflowNotificationUtils.sendWorkflowAssignedNotificationEMail(services, taskId, new String[]{assignedAuthority}, pooled);
    }
}

