/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.tenant.MultiTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Filter;
import org.alfresco.util.collections.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowObjectFactory {
    private static final String TITLE_LABEL = "title";
    private static final String DESC_LABEL = "description";
    private final WorkflowQNameConverter qNameConverter;
    private final TenantService tenantService;
    private final MessageService messageService;
    private final DictionaryService dictionaryService;
    private final String engineId;
    private final QName defaultStartTaskType;

    public WorkflowObjectFactory(WorkflowQNameConverter qNameConverter, TenantService tenantService, MessageService messageService, DictionaryService dictionaryService, String engineId, QName defaultStartTaskType) {
        this.tenantService = tenantService;
        this.messageService = messageService;
        this.dictionaryService = dictionaryService;
        this.engineId = engineId;
        this.qNameConverter = qNameConverter;
        this.defaultStartTaskType = defaultStartTaskType;
    }

    public String buildGlobalId(String localId) {
        return BPMEngineRegistry.createGlobalId(this.engineId, localId);
    }

    public String getLocalEngineId(String globalId) {
        return BPMEngineRegistry.getLocalId(globalId);
    }

    public boolean isGlobalId(String globalId) {
        return BPMEngineRegistry.isGlobalId(globalId, this.engineId);
    }

    public WorkflowDeployment createDeployment(WorkflowDefinition wfDef, String ... problems) {
        WorkflowDeployment wfDeployment = new WorkflowDeployment(wfDef, problems);
        return wfDeployment;
    }

    public WorkflowDefinition createDefinition(String defId, String defName, int version, String defaultTitle, String defaultDescription, WorkflowTaskDefinition startTaskDef) {
        this.checkDomain(defName);
        String actualDefName = this.buildGlobalId(this.tenantService.getBaseName(defName));
        String actualId = this.buildGlobalId(defId);
        String actualVersion = Integer.toString(version);
        String displayId = this.getProcessKey(defName) + ".workflow";
        String title = this.getLabel(displayId, TITLE_LABEL, defaultTitle);
        String description = this.getLabel(displayId, DESC_LABEL, defaultDescription, title);
        return new WorkflowDefinition(actualId, actualDefName, actualVersion, title, description, startTaskDef);
    }

    public String getWorkflowDefinitionName(String defName) {
        String baseName = this.tenantService.getBaseName(defName);
        String actualName = this.buildGlobalId(baseName);
        return actualName;
    }

    public WorkflowInstance createInstance(String id, WorkflowDefinition definition, Map<String, Object> variables, boolean isActive, Date startDate, Date endDate) {
        String actualId = this.buildGlobalId(id);
        String description = (String)this.getVariable(variables, WorkflowModel.PROP_WORKFLOW_DESCRIPTION);
        NodeRef initiator = null;
        ScriptNode initiatorSN = (ScriptNode)this.getVariable(variables, "initiator");
        if (initiatorSN != null) {
            initiator = initiatorSN.getNodeRef();
        }
        NodeRef context = this.getNodeVariable(variables, WorkflowModel.PROP_CONTEXT);
        NodeRef workflowPackage = this.getNodeVariable(variables, WorkflowModel.ASSOC_PACKAGE);
        WorkflowInstance workflowInstance = new WorkflowInstance(actualId, definition, description, initiator, workflowPackage, context, isActive, startDate, endDate);
        workflowInstance.priority = (Integer)this.getVariable(variables, WorkflowModel.PROP_WORKFLOW_PRIORITY);
        Date dueDate = (Date)this.getVariable(variables, WorkflowModel.PROP_WORKFLOW_DUE_DATE);
        if (dueDate != null) {
            workflowInstance.dueDate = dueDate;
        }
        return workflowInstance;
    }

    public WorkflowPath createPath(String id, WorkflowInstance wfInstance, WorkflowNode node, boolean isActive) {
        String actualId = this.buildGlobalId(id);
        return new WorkflowPath(actualId, wfInstance, node, isActive);
    }

    public WorkflowNode createNode(String name, String definitionName, String defaultTitle, String defaultDescription, String type, boolean isTaskNode, WorkflowTransition ... transitions) {
        String displayId = definitionName + ".node." + name;
        String title = this.getLabel(displayId, TITLE_LABEL, defaultTitle);
        String description = this.getLabel(displayId, DESC_LABEL, defaultDescription, title);
        return new WorkflowNode(name, title, description, type, isTaskNode, transitions);
    }

    public WorkflowTransition createTransition(String id, String defaultTitle, String defaultDescription, boolean isDefault, String ... baseLabelKeys) {
        String title = this.getLabel(baseLabelKeys, TITLE_LABEL, defaultTitle);
        String description = this.getLabel(baseLabelKeys, TITLE_LABEL, defaultDescription);
        return new WorkflowTransition(id, title, description, isDefault);
    }

    public WorkflowTaskDefinition createTaskDefinition(String id, WorkflowNode node, String typeName, boolean isStart) {
        TypeDefinition metaData = this.getTaskTypeDefinition(typeName, isStart);
        if (id == null) {
            id = this.qNameConverter.mapQNameToName(metaData.getName());
        }
        return new WorkflowTaskDefinition(id, node, metaData);
    }

    public WorkflowTask createTask(String id, WorkflowTaskDefinition taskDef, String name, String defaultTitle, String defaultDescription, WorkflowTaskState state, WorkflowPath path, Map<QName, Serializable> properties) {
        String defName = path.getInstance().getDefinition().getName();
        String actualId = this.buildGlobalId(id);
        String processKey = this.getProcessKey(defName) + ".task." + name;
        TypeDefinition metadata = taskDef.getMetadata();
        String title = this.getLabel(processKey, TITLE_LABEL, metadata.getTitle(), defaultTitle, name);
        String description = this.getLabel(processKey, DESC_LABEL, metadata.getDescription(), title, defaultDescription);
        return new WorkflowTask(actualId, taskDef, name, title, description, state, path, properties);
    }

    public WorkflowTimer createWorkflowTimer(String id, String name, String error, Date dueDate, WorkflowPath workflowPath, WorkflowTask workflowTask) {
        String actualId = this.buildGlobalId(id);
        return new WorkflowTimer(actualId, name, workflowPath, workflowTask, dueDate, error);
    }

    public String getProcessKey(String defName) {
        String processKey = defName;
        if (this.isGlobalId(defName)) {
            processKey = this.getLocalEngineId(defName);
        }
        return this.tenantService.getBaseName(processKey);
    }

    public String getDomainProcessKey(String defName) {
        String processKey = defName;
        if (this.isGlobalId(defName)) {
            processKey = this.getLocalEngineId(defName);
        }
        return this.tenantService.getName(processKey);
    }

    public String getTaskTitle(TypeDefinition typeDefinition, String defName, String defaultTitle, String name) {
        String displayId = this.getProcessKey(defName) + ".task." + name;
        return this.getLabel(displayId, TITLE_LABEL, defaultTitle, typeDefinition.getTitle(), name);
    }

    public String getTaskDescription(TypeDefinition typeDefinition, String defName, String defaultDescription, String title) {
        String displayId = this.getProcessKey(defName) + ".task." + title;
        return this.getLabel(displayId, DESC_LABEL, defaultDescription);
    }

    private String getLabel(String displayId, String labelKey, String ... defaults) {
        String keyBase = displayId.replace(":", "_");
        String key = keyBase + "." + labelKey;
        String label = this.messageService.getMessage(key);
        return this.getDefaultLabel(label, defaults);
    }

    private String getLabel(String[] locations, String labelKey, String ... defaults) {
        String label = null;
        for (int i = 0; label == null && i < locations.length; ++i) {
            label = this.getLabel(locations[i], labelKey, new String[0]);
        }
        return this.getDefaultLabel(label, defaults);
    }

    private String getDefaultLabel(String label, String ... defaults) {
        for (int i = 0; label == null && i < defaults.length; ++i) {
            label = defaults[i];
        }
        return label;
    }

    private NodeRef getNodeVariable(Map<String, Object> variables, QName qName) {
        Object obj = this.getVariable(variables, qName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof ScriptNode) {
            ScriptNode scriptNode = (ScriptNode)obj;
            return scriptNode.getNodeRef();
        }
        String message = "Variable " + qName + " should be of type ScriptNode but was " + obj.getClass();
        throw new WorkflowException(message);
    }

    private Object getVariable(Map<String, Object> variables, QName qName) {
        if (variables == null || qName == null) {
            return null;
        }
        String varName = this.qNameConverter.mapQNameToName(qName);
        return variables.get(varName);
    }

    private Object getVariable(Map<String, Object> variables, String key) {
        if (variables == null || key == null) {
            return null;
        }
        return variables.get(key);
    }

    public void checkDomain(String defName) {
        if (this.tenantService.isEnabled()) {
            String processKey = defName;
            if (this.isGlobalId(defName)) {
                processKey = this.getLocalEngineId(defName);
            }
            this.tenantService.checkDomain(processKey);
        }
    }

    public <T> List<T> filterByDomain(Collection<T> values, final Function<T, String> processKeyGetter) {
        final String currentDomain = this.tenantService.getCurrentUserDomain();
        return CollectionUtils.filter(values, (Function)new Filter<T>(){

            public Boolean apply(T value) {
                String key = (String)processKeyGetter.apply(value);
                String domain = MultiTServiceImpl.getMultiTenantDomainName(key);
                return currentDomain.equals(domain);
            }
        });
    }

    public TypeDefinition getTaskFullTypeDefinition(String name, boolean isStart) {
        TypeDefinition typeDef = this.getTaskTypeDefinition(name, isStart);
        return this.dictionaryService.getAnonymousType(typeDef.getName());
    }

    public TypeDefinition getTaskTypeDefinition(String name, boolean isStart) {
        QName defaultTypeName;
        TypeDefinition typeDef = null;
        if (name != null) {
            QName typeName = this.qNameConverter.mapNameToQName(name);
            typeDef = this.dictionaryService.getType(typeName);
        }
        if (typeDef == null && (typeDef = this.dictionaryService.getType(defaultTypeName = isStart ? this.defaultStartTaskType : WorkflowModel.TYPE_WORKFLOW_TASK)) == null) {
            String msg = this.messageService.getMessage("workflow.get.task.definition.metadata.error", name);
            throw new WorkflowException(msg);
        }
        return typeDef;
    }

    public String mapQNameToName(QName name) {
        return this.qNameConverter.mapQNameToName(name);
    }

    public QName mapNameToQName(String name) {
        return this.qNameConverter.mapNameToQName(name);
    }

    public void clearQNameCache() {
        this.qNameConverter.clearCache();
    }
}

