/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.workflow.WorkflowPropertyHandler;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowPropertyHandlerRegistry {
    private final Map<QName, WorkflowPropertyHandler> handlers = new HashMap<QName, WorkflowPropertyHandler>();
    private final WorkflowPropertyHandler defaultHandler;
    private final WorkflowQNameConverter qNameConverter;

    public WorkflowPropertyHandlerRegistry(WorkflowPropertyHandler defaultHandler, WorkflowQNameConverter qNameConverter) {
        this.defaultHandler = defaultHandler;
        this.qNameConverter = qNameConverter;
    }

    public void registerHandler(QName key, WorkflowPropertyHandler handler) {
        this.handlers.put(key, handler);
    }

    public void clear() {
        this.handlers.clear();
    }

    public Map<String, Object> handleVariablesToSet(Map<QName, Serializable> properties, TypeDefinition type, Object object, Class<?> objectType) {
        HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            Object result;
            QName key = entry.getKey();
            Serializable value = entry.getValue();
            WorkflowPropertyHandler handler = this.handlers.get(key);
            if (handler == null) {
                handler = this.defaultHandler;
            }
            if ("*\u00a3$DO NOT ADD THIS PROPERTY $\u00a3*".equals(result = handler.handleProperty(key, value, type, object, objectType))) continue;
            String keyStr = this.qNameConverter.mapQNameToName(key);
            variablesToSet.put(keyStr, result);
        }
        return variablesToSet;
    }
}

