/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.util.Arrays;
import java.util.Set;
import org.alfresco.repo.workflow.WorkflowAdminServiceImpl;

public class WorkflowTestHelper {
    private final WorkflowAdminServiceImpl workflowAdminService;
    private final String engineId;
    private final Set<String> enabledEngines;
    private final Set<String> visibleEngines;

    public WorkflowTestHelper(WorkflowAdminServiceImpl workflowAdminService, String engineId, boolean enableEngineOnly) {
        this.workflowAdminService = workflowAdminService;
        this.engineId = engineId;
        this.enabledEngines = workflowAdminService.getEnabledEngines();
        this.visibleEngines = workflowAdminService.getVisibleEngines();
        if (enableEngineOnly) {
            this.enableThisEngineOnly();
        }
    }

    public void enableThisEngineOnly() {
        this.workflowAdminService.setEnabledEngines(Arrays.asList(this.engineId));
        this.workflowAdminService.setVisibleEngines(Arrays.asList(this.engineId));
    }

    public void tearDown() {
        this.workflowAdminService.setEnabledEngines(this.enabledEngines);
        this.workflowAdminService.setVisibleEngines(this.visibleEngines);
    }

    public void setVisible(boolean isVisible) {
        this.workflowAdminService.setEngineVisibility(this.engineId, isVisible);
    }

    public void setEnabled(boolean isEnabled) {
        this.workflowAdminService.setEngineEnabled(this.engineId, isEnabled);
    }
}

