/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.script;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.script.ActivitiScriptBase;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateExecutionScriptBase
extends ActivitiScriptBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void runScript(DelegateExecution execution) throws Exception {
        if (this.script == null) throw new IllegalArgumentException("The field 'script' should be set on the TaskListener");
        String scriptString = this.getStringValue(this.script, (VariableScope)execution);
        String scriptProcessorName = this.getStringValue(this.scriptProcessor, (VariableScope)execution);
        String runAsUser = this.getStringValue(this.runAs, (VariableScope)execution);
        boolean clearAuthenticationContext = this.checkFullyAuthenticatedUser(execution);
        Map<String, Object> scriptModel = this.getInputMap(execution, runAsUser);
        this.getServiceRegistry().getScriptService().buildCoreModel(scriptModel);
        try {
            Object scriptOutput = this.executeScript(scriptString, scriptModel, scriptProcessorName, runAsUser);
            if (scriptOutput != null) {
                // empty if block
            }
            Object var9_8 = null;
            if (!clearAuthenticationContext) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!clearAuthenticationContext) throw throwable;
            AuthenticationUtil.clearCurrentSecurityContext();
            throw throwable;
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected Map<String, Object> getInputMap(DelegateExecution execution, String runAsUser) {
        HashMap<String, Object> scriptModel = new HashMap<String, Object>(1);
        ActivitiScriptNode personNode = this.getPersonNode(runAsUser);
        if (personNode != null) {
            ServiceRegistry registry = this.getServiceRegistry();
            scriptModel.put("person", personNode);
            NodeRef userHomeNode = (NodeRef)registry.getNodeService().getProperty(personNode.getNodeRef(), ContentModel.PROP_HOMEFOLDER);
            if (userHomeNode != null) {
                scriptModel.put("userhome", new ActivitiScriptNode(userHomeNode, registry));
            }
        }
        scriptModel.put("execution", execution);
        Map variables = execution.getVariables();
        for (Map.Entry varEntry : variables.entrySet()) {
            scriptModel.put((String)varEntry.getKey(), varEntry.getValue());
        }
        return scriptModel;
    }

    private boolean checkFullyAuthenticatedUser(DelegateExecution execution) {
        NamespaceService namespaceService;
        WorkflowQNameConverter qNameConverter;
        String ownerVariableName;
        String userName;
        if (AuthenticationUtil.getFullyAuthenticatedUser() == null && (userName = (String)execution.getVariable(ownerVariableName = (qNameConverter = new WorkflowQNameConverter((NamespacePrefixResolver)(namespaceService = this.getServiceRegistry().getNamespaceService()))).mapQNameToName(ContentModel.PROP_OWNER))) != null) {
            AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
            return true;
        }
        return false;
    }
}

