/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.jbpm.AlfrescoJavaScript;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class AlfrescoJavaScriptIntegrationTest
extends BaseAlfrescoSpringTest {
    private static final QName fooName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"Foo");
    private static final QName barName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"Bar");
    private static final QName docName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"Doc");
    private static final String BASIC_USER = "basic" + GUID.generate();
    private static String systemUser = AuthenticationUtil.getSystemUserName();
    private ServiceRegistry services;
    private ExecutionContext context;
    private HashMap<String, Object> variables;
    private PersonService personService;
    private Repository repository;

    public void testRunsWithoutAuthentication() throws Exception {
        NodeRef systemNode = this.personService.getPerson(systemUser);
        NodeRef baseUserNode = this.personService.getPerson(BASIC_USER);
        TestUserStore userStore = new TestUserStore();
        this.variables.put("userStore", userStore);
        Element script = this.buildScript("userStore.storeUsers(person)");
        AuthenticationUtil.clearCurrentSecurityContext();
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
        AlfrescoJavaScript scriptHandler = new AlfrescoJavaScript();
        scriptHandler.setScript(script);
        scriptHandler.execute(this.context);
        AlfrescoJavaScriptIntegrationTest.assertEquals((String)systemUser, (String)userStore.runAsUser);
        AlfrescoJavaScriptIntegrationTest.assertEquals((String)systemUser, (String)userStore.fullUser);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)systemNode, (Object)userStore.person.getNodeRef());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
        TaskInstance taskInstance = (TaskInstance)Mockito.mock(TaskInstance.class);
        Mockito.when((Object)taskInstance.getActorId()).thenReturn((Object)BASIC_USER);
        Mockito.when((Object)this.context.getTaskInstance()).thenReturn((Object)taskInstance);
        scriptHandler = new AlfrescoJavaScript();
        scriptHandler.setScript(script);
        scriptHandler.execute(this.context);
        AlfrescoJavaScriptIntegrationTest.assertEquals((String)BASIC_USER, (String)userStore.runAsUser);
        AlfrescoJavaScriptIntegrationTest.assertEquals((String)BASIC_USER, (String)userStore.fullUser);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)baseUserNode, (Object)userStore.person.getNodeRef());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
    }

    public void testRunAsAdminMoveContent() throws Exception {
        AlfrescoJavaScript scriptHandler;
        NodeRef fooFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, fooName, ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef barFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, barName, ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef doc = this.nodeService.createNode(fooFolder, ContentModel.ASSOC_CONTAINS, docName, ContentModel.TYPE_CONTENT).getChildRef();
        PermissionService permissions = this.services.getPermissionService();
        permissions.setPermission(doc, BASIC_USER, "All", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)BASIC_USER);
        Element script = this.buildScript("doc.move(bar)");
        this.variables.put("doc", new JBPMNode(doc, this.services));
        this.variables.put("bar", new JBPMNode(barFolder, this.services));
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)fooFolder, (Object)this.nodeService.getPrimaryParent(doc).getParentRef());
        try {
            scriptHandler = new AlfrescoJavaScript();
            scriptHandler.setScript(script);
            scriptHandler.execute(this.context);
            AlfrescoJavaScriptIntegrationTest.fail((String)"The user should not have permission to write to bar!");
        }
        catch (ScriptException e) {
            // empty catch block
        }
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)fooFolder, (Object)this.nodeService.getPrimaryParent(doc).getParentRef());
        scriptHandler = new AlfrescoJavaScript();
        scriptHandler.setScript(script);
        scriptHandler.setRunas(AuthenticationUtil.getAdminUserName());
        scriptHandler.execute(this.context);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)barFolder, (Object)this.nodeService.getPrimaryParent(doc).getParentRef());
    }

    public void testRunAsAdminMoveContentBetweenSites() throws Exception {
        AlfrescoJavaScript scriptHandler;
        SiteService siteService = this.services.getSiteService();
        FileFolderService fileFolderService = this.services.getFileFolderService();
        String siteAName = "siteA" + GUID.generate();
        String siteBName = "siteB" + GUID.generate();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        siteService.createSite("testSitePreset", siteAName, "title", "description", SiteVisibility.PRIVATE);
        siteService.createSite("testSitePreset", siteBName, "title", "description", SiteVisibility.PRIVATE);
        NodeRef docLibA = siteService.createContainer(siteAName, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        NodeRef docLibB = siteService.createContainer(siteBName, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        FileInfo docInfo = fileFolderService.create(docLibA, "test.txt", ContentModel.TYPE_CONTENT);
        NodeRef doc = docInfo.getNodeRef();
        ContentWriter writer = fileFolderService.getWriter(doc);
        writer.putContent("Just some old content that doesn't mean anything");
        AuthenticationUtil.setFullyAuthenticatedUser((String)BASIC_USER);
        Element script = this.buildScript("doc.move(companyhome.childByNamePath(\"Sites/" + siteBName + "/documentLibrary\"))");
        NodeRef companyHome = this.repository.getCompanyHome();
        this.variables.put("companyhome", new JBPMNode(companyHome, this.services));
        this.variables.put("doc", new JBPMNode(doc, this.services));
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)docLibA, (Object)this.nodeService.getPrimaryParent(doc).getParentRef());
        try {
            scriptHandler = new AlfrescoJavaScript();
            scriptHandler.setScript(script);
            scriptHandler.execute(this.context);
            AlfrescoJavaScriptIntegrationTest.fail((String)"The user should not have permission to write to Site B!");
        }
        catch (ScriptException e) {
            // empty catch block
        }
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)docLibA, (Object)this.nodeService.getPrimaryParent(doc).getParentRef());
        scriptHandler = new AlfrescoJavaScript();
        scriptHandler.setScript(script);
        scriptHandler.setRunas(AuthenticationUtil.getAdminUserName());
        scriptHandler.execute(this.context);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)docLibB, (Object)this.nodeService.getPrimaryParent(doc).getParentRef());
    }

    public void testScopeVariables() throws Exception {
        String admin = AuthenticationUtil.getAdminUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)admin);
        NodeRef person = this.personService.getPerson(admin);
        Serializable userHome = this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        AlfrescoJavaScript scriptHandler = new AlfrescoJavaScript();
        String key = "result";
        Element script = this.buildScript("executionContext.setVariable('" + key + "', person)");
        scriptHandler.setScript(script);
        scriptHandler.execute(this.context);
        ScriptNode value = (ScriptNode)this.variables.get(key);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)person, (Object)value.getNodeRef());
        script = this.buildScript("executionContext.setVariable('" + key + "', userhome)");
        scriptHandler.setScript(script);
        scriptHandler.execute(this.context);
        value = (ScriptNode)this.variables.get(key);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)userHome, (Object)value.getNodeRef());
        NodeRef companyHome = this.repository.getCompanyHome();
        script = this.buildScript("executionContext.setVariable('" + key + "', companyhome)");
        scriptHandler.setScript(script);
        scriptHandler.execute(this.context);
        value = (ScriptNode)this.variables.get(key);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)companyHome, (Object)value.getNodeRef());
    }

    private Element buildScript(String expression) {
        Element script = DocumentHelper.createElement((String)"script");
        script.setText(expression);
        return script;
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
        this.services = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.repository = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.personService = this.services.getPersonService();
        this.createUser(BASIC_USER);
        this.context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        ContextInstance contextInstance = (ContextInstance)Mockito.mock(ContextInstance.class);
        Mockito.when((Object)this.context.getContextInstance()).thenReturn((Object)contextInstance);
        this.variables = new HashMap();
        Mockito.when((Object)contextInstance.getVariables()).thenReturn(this.variables);
        Mockito.when((Object)contextInstance.getVariables((Token)Matchers.any(Token.class))).thenReturn(this.variables);
        Mockito.when((Object)this.context.getVariable(Matchers.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String key = (String)invocation.getArguments()[0];
                return AlfrescoJavaScriptIntegrationTest.this.variables.get(key);
            }
        });
        ((ExecutionContext)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                String key = (String)invocation.getArguments()[0];
                Object value = invocation.getArguments()[1];
                AlfrescoJavaScriptIntegrationTest.this.variables.put(key, value);
                return null;
            }
        }).when((Object)this.context)).setVariable(Matchers.anyString(), Matchers.any());
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
            ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            this.personService.createPerson(ppOne);
        }
    }

    public static class TestUserStore {
        private String runAsUser;
        private String fullUser;
        private ScriptNode person = null;

        public void storeUsers(ScriptNode user) {
            this.fullUser = AuthenticationUtil.getFullyAuthenticatedUser();
            this.runAsUser = AuthenticationUtil.getRunAsUser();
            this.person = user;
        }
    }
}

