/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.InputStream;
import org.hibernate.SessionFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.configuration.ObjectFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springmodules.workflow.jbpm31.JbpmFactoryLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoJbpmConfigurationFactoryBean
implements InitializingBean,
FactoryBean<JbpmConfiguration>,
BeanFactoryAware,
BeanNameAware,
DisposableBean {
    private JbpmConfiguration jbpmConfiguration;
    private ObjectFactory objectFactory;
    private Resource configuration;
    private SessionFactory sessionFactory;
    private String contextName = "default.jbpm.context";
    private final AlfrescoJbpmFactoryLocator factoryLocator = new AlfrescoJbpmFactoryLocator();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.factoryLocator.destroy();
        this.factoryLocator.setBeanFactory(beanFactory);
    }

    public void setBeanName(String name) {
        this.factoryLocator.setBeanName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.configuration == null) {
            throw new IllegalArgumentException("configuration or objectFactory property need to be not null");
        }
        InputStream stream = this.configuration.getInputStream();
        this.jbpmConfiguration = JbpmConfiguration.parseInputStream((InputStream)stream);
        if (this.sessionFactory != null) {
            JbpmContext context = this.jbpmConfiguration.createJbpmContext(this.contextName);
            try {
                context.setSessionFactory(this.sessionFactory);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                context.close();
                throw throwable;
            }
            context.close();
            {
            }
        }
    }

    public JbpmConfiguration getObject() throws Exception {
        return this.jbpmConfiguration;
    }

    public Class<JbpmConfiguration> getObjectType() {
        return JbpmConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Resource getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Resource configuration) {
        this.configuration = configuration;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void destroy() throws Exception {
        this.factoryLocator.destroy();
    }

    private static class AlfrescoJbpmFactoryLocator
    extends JbpmFactoryLocator {
        private AlfrescoJbpmFactoryLocator() {
        }

        public void destroy() {
            JbpmFactoryLocator.beanFactories.clear();
            JbpmFactoryLocator.beanFactoriesNames.clear();
            JbpmFactoryLocator.referenceCounter.clear();
            JbpmFactoryLocator.canUseDefaultBeanFactory = true;
            JbpmFactoryLocator.defaultFactory = null;
        }
    }
}

