/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.alfresco.repo.workflow.jbpm.AlfrescoJavaScript;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.instantiation.FieldInstantiator;
import org.springframework.beans.factory.BeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachFork
extends JBPMSpringActionHandler {
    private static final long serialVersionUID = 4643103713602441652L;
    private ServiceRegistry services;
    private Element foreach;
    private String var;

    @Override
    protected void initialiseHandler(BeanFactory factory) {
        this.services = (ServiceRegistry)factory.getBean("ServiceRegistry");
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        if (this.foreach == null) {
            throw new WorkflowException("forEach has not been provided");
        }
        if (this.var == null || this.var.length() == 0) {
            throw new WorkflowException("forEach variable name has not been provided");
        }
        Node node = executionContext.getNode();
        ArrayList<ForkedTransition> forkTransitions = new ArrayList<ForkedTransition>();
        Collection<?> forEachColl = this.buildForEachCollection(executionContext);
        List nodeTransitions = node.getLeavingTransitions();
        for (Transition noderansition : nodeTransitions) {
            int iVar = 0;
            for (Object item : forEachColl) {
                Token loopToken = this.buildChildToken(executionContext, noderansition, iVar);
                ++iVar;
                ExecutionContext newExecutionContext = new ExecutionContext(loopToken);
                newExecutionContext.getContextInstance().createVariable(this.var, item, loopToken);
                ForkedTransition forkTransition = new ForkedTransition();
                forkTransition.executionContext = newExecutionContext;
                forkTransition.transition = noderansition;
                forkTransitions.add(forkTransition);
            }
        }
        for (ForkedTransition forkTransition : forkTransitions) {
            node.leave(forkTransition.executionContext, forkTransition.transition);
        }
    }

    private Token buildChildToken(ExecutionContext executionContext, Transition noderansition, int iVar) {
        Token rootToken = executionContext.getToken();
        String tokenName = this.getTokenName(rootToken, noderansition.getName(), iVar);
        Token loopToken = new Token(rootToken, tokenName);
        loopToken.setTerminationImplicit(true);
        executionContext.getJbpmContext().getSession().save((Object)loopToken);
        return loopToken;
    }

    private Collection<?> buildForEachCollection(ExecutionContext executionContext) {
        String text = this.foreach.getTextTrim();
        if (text != null && text.startsWith("#{")) {
            return this.evaluateForEachExpression(executionContext, text);
        }
        return (Collection)FieldInstantiator.getValue(List.class, (Element)this.foreach);
    }

    private Collection<?> evaluateForEachExpression(ExecutionContext executionContext, String forEachText) {
        String expression = forEachText.substring(2, forEachText.length() - 1);
        Object result = AlfrescoJavaScript.executeScript(executionContext, this.services, expression, null, null);
        if (result == null) {
            throw new WorkflowException("forEach expression '" + forEachText + "' evaluates to null");
        }
        if (result instanceof String) {
            return this.buildStrings((String)result);
        }
        if (result instanceof Serializable[]) {
            return this.buildJbpmNodes((Serializable[])result);
        }
        if (result instanceof Collection) {
            return (Collection)result;
        }
        return null;
    }

    private List<?> buildStrings(String result) {
        String[] results = result.trim().split(",");
        return Arrays.asList(results);
    }

    private List<?> buildJbpmNodes(Serializable[] nodes) {
        ArrayList<JBPMNode> jbpmNodes = new ArrayList<JBPMNode>(nodes.length);
        for (Serializable node : nodes) {
            if (!(node instanceof NodeRef)) continue;
            JBPMNode jbpmNode = new JBPMNode((NodeRef)node, this.services);
            jbpmNodes.add(jbpmNode);
        }
        return jbpmNodes;
    }

    protected String getTokenName(Token parent, String transitionName, int loopIndex) {
        String suffix = "." + loopIndex;
        if (transitionName == null || transitionName.isEmpty()) {
            int size = parent.getChildren() != null ? parent.getChildren().size() + 1 : 1;
            return this.buildTokenName("FOREACHFORK", suffix, size);
        }
        return this.findFirstAvailableTokenName(parent, transitionName, suffix);
    }

    private String findFirstAvailableTokenName(Token parent, String transitionName, String suffix) {
        int i = 1;
        String tokenName;
        while (parent.hasChild(tokenName = this.buildTokenName(transitionName, suffix, i))) {
            ++i;
        }
        return tokenName;
    }

    private String buildTokenName(String prefix, String suffix, int count) {
        String countStr = count < 2 ? "" : Integer.toString(count);
        return prefix + countStr + suffix;
    }

    public void setForeach(Element foreach) {
        this.foreach = foreach;
    }

    public void setVar(String var) {
        this.var = var;
    }

    private class ForkedTransition {
        private ExecutionContext executionContext;
        private Transition transition;

        private ForkedTransition() {
        }
    }
}

