/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowPackageComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.PropertyMap;
import org.springframework.core.io.ClassPathResource;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBPMEngineTest
extends BaseAlfrescoSpringTest {
    private static final String USER1 = "JbpmEngineTestJohn";
    private static final String USER2 = "JbpmEngineTestJane";
    private static final String USER3 = "JbpmEngineTestJoe";
    private WorkflowComponent workflowComponent;
    private TaskComponent taskComponent;
    private WorkflowPackageComponent packageComponent;
    private PersonService personService;
    private WorkflowDefinition testWorkflowDef;
    private NodeRef person1;
    private NodeRef person2;
    private NodeRef person3;

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.person1 = this.createPerson(USER1);
        this.person2 = this.createPerson(USER2);
        this.person3 = this.createPerson(USER3);
        BPMEngineRegistry registry = (BPMEngineRegistry)this.applicationContext.getBean("bpm_engineRegistry");
        this.workflowComponent = registry.getWorkflowComponent("jbpm");
        this.taskComponent = registry.getTaskComponent("jbpm");
        this.packageComponent = (WorkflowPackageComponent)this.applicationContext.getBean("workflowPackageImpl");
        I18NUtil.registerResourceBundle((String)"jbpmresources/test-messages");
        ClassPathResource processDef = new ClassPathResource("jbpmresources/test_processdefinition.xml");
        JBPMEngineTest.assertFalse((boolean)this.workflowComponent.isDefinitionDeployed(processDef.getInputStream(), "text/xml"));
        WorkflowDeployment deployment = this.workflowComponent.deployDefinition(processDef.getInputStream(), "text/xml");
        this.testWorkflowDef = deployment.definition;
        JBPMEngineTest.assertNotNull((Object)this.testWorkflowDef);
        JBPMEngineTest.assertEquals((String)"jbpm$test", (String)this.testWorkflowDef.name);
        JBPMEngineTest.assertEquals((String)"1", (String)this.testWorkflowDef.version);
        JBPMEngineTest.assertTrue((boolean)this.workflowComponent.isDefinitionDeployed(processDef.getInputStream(), "text/xml"));
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
    }

    public void todoTestGetStartTask() throws Exception {
    }

    public void testGetWorkflowDefinitions() {
        List<WorkflowDefinition> workflowDefs = this.workflowComponent.getDefinitions();
        JBPMEngineTest.assertNotNull(workflowDefs);
        JBPMEngineTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
    }

    public void testDeployWorkflow() throws Exception {
        ClassPathResource processDef = new ClassPathResource("jbpmresources/test_processdefinition.xml");
        WorkflowDeployment deployment = this.workflowComponent.deployDefinition(processDef.getInputStream(), "text/xml");
        this.testWorkflowDef = deployment.getDefinition();
        JBPMEngineTest.assertNotNull((Object)this.testWorkflowDef);
        JBPMEngineTest.assertEquals((String)"jbpm$test", (String)this.testWorkflowDef.getName());
        JBPMEngineTest.assertEquals((String)"2", (String)this.testWorkflowDef.getVersion());
    }

    public void testStartWorkflow() {
        try {
            this.workflowComponent.startWorkflow("norfolknchance", null);
            JBPMEngineTest.fail((String)"Failed to catch invalid definition id");
        }
        catch (WorkflowException e) {
            // empty catch block
        }
        WorkflowDefinition workflowDef = this.getTestDefinition();
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), null);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertTrue((boolean)path.getId().endsWith("-@"));
        JBPMEngineTest.assertNotNull((Object)path.getNode());
        JBPMEngineTest.assertNotNull((Object)path.getInstance());
        JBPMEngineTest.assertEquals((String)workflowDef.getId(), (String)path.getInstance().getDefinition().getId());
    }

    public void testGetWorkflowById() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), null);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertTrue((boolean)path.getId().endsWith("-@"));
        JBPMEngineTest.assertNotNull((Object)path.getNode());
        JBPMEngineTest.assertNotNull((Object)path.getInstance());
        JBPMEngineTest.assertEquals((String)workflowDef.getId(), (String)path.getInstance().getDefinition().getId());
        WorkflowInstance instance = this.workflowComponent.getWorkflowById(path.getInstance().getId());
        JBPMEngineTest.assertNotNull((Object)instance);
        JBPMEngineTest.assertEquals((String)path.getInstance().getId(), (String)instance.getId());
        this.workflowComponent.cancelWorkflow(instance.getId());
        WorkflowInstance result = this.workflowComponent.getWorkflowById(instance.getId());
        JBPMEngineTest.assertNull((String)"The workflow isntance should be null!", (Object)result);
    }

    public void testStartWorkflowParameters() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.PROP_TASK_ID, Integer.valueOf(3));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(1));
        params.put(WorkflowModel.PROP_PERCENT_COMPLETE, Integer.valueOf(10));
        params.put(QName.createQName((String)"", (String)"Message"), (Serializable)((Object)"Hello World"));
        params.put(QName.createQName((String)"", (String)"Array"), (Serializable)new String[]{"one", "two"});
        params.put(QName.createQName((String)"", (String)"NodeRef"), (Serializable)new NodeRef("workspace://1/1001"));
        params.put(ContentModel.PROP_OWNER, (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), params);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertTrue((boolean)path.getId().endsWith("-@"));
        JBPMEngineTest.assertNotNull((Object)path.getNode());
        JBPMEngineTest.assertNotNull((Object)path.getInstance());
        JBPMEngineTest.assertEquals((String)workflowDef.getId(), (String)path.getInstance().getDefinition().getId());
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask task = tasks1.get(0);
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.PROP_TASK_ID));
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.PROP_DUE_DATE));
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.PROP_PRIORITY));
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.PROP_PERCENT_COMPLETE));
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(ContentModel.PROP_OWNER));
        NodeRef initiator = path.getInstance().getInitiator();
        String initiatorUsername = (String)((Object)this.nodeService.getProperty(initiator, ContentModel.PROP_USERNAME));
        JBPMEngineTest.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)initiatorUsername);
    }

    public void testUpdateTask() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.PROP_TASK_ID, Integer.valueOf(3));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(1));
        params.put(WorkflowModel.PROP_PERCENT_COMPLETE, Integer.valueOf(10));
        params.put(QName.createQName((String)"", (String)"Message"), (Serializable)((Object)"Hello World"));
        params.put(QName.createQName((String)"", (String)"Array"), (Serializable)new String[]{"one", "two"});
        params.put(QName.createQName((String)"", (String)"NodeRef"), (Serializable)new NodeRef("workspace://1/1001"));
        params.put(ContentModel.PROP_OWNER, (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), params);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertTrue((boolean)path.getId().endsWith("-@"));
        JBPMEngineTest.assertNotNull((Object)path.getNode());
        JBPMEngineTest.assertNotNull((Object)path.getInstance());
        JBPMEngineTest.assertEquals((String)workflowDef.getId(), (String)path.getInstance().getDefinition().getId());
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask task = tasks1.get(0);
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.PROP_TASK_ID));
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.PROP_DUE_DATE));
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.PROP_PRIORITY));
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.PROP_PERCENT_COMPLETE));
        JBPMEngineTest.assertTrue((boolean)task.getProperties().containsKey(ContentModel.PROP_OWNER));
        try {
            WorkflowTask taskU1 = this.taskComponent.updateTask(task.getId(), null, null, null);
            JBPMEngineTest.assertNotNull((Object)taskU1);
        }
        catch (Throwable e) {
            JBPMEngineTest.fail((String)"Task update failed with null parameters");
        }
        HashMap<QName, Serializable> updateProperties2 = new HashMap<QName, Serializable>();
        updateProperties2.put(WorkflowModel.PROP_PERCENT_COMPLETE, Integer.valueOf(100));
        WorkflowTask taskU2 = this.taskComponent.updateTask(task.getId(), updateProperties2, null, null);
        JBPMEngineTest.assertEquals((Object)100, (Object)taskU2.getProperties().get(WorkflowModel.PROP_PERCENT_COMPLETE));
        QName assocName = QName.createQName((String)"", (String)"TestAssoc");
        ArrayList<NodeRef> toAdd = new ArrayList<NodeRef>();
        toAdd.add(new NodeRef("workspace://1/1001"));
        toAdd.add(new NodeRef("workspace://1/1002"));
        toAdd.add(new NodeRef("workspace://1/1003"));
        HashMap<QName, List<NodeRef>> addAssocs = new HashMap<QName, List<NodeRef>>();
        addAssocs.put(assocName, toAdd);
        WorkflowTask taskU3 = this.taskComponent.updateTask(task.getId(), null, addAssocs, null);
        JBPMEngineTest.assertNotNull((Object)taskU3.getProperties().get(assocName));
        JBPMEngineTest.assertEquals((int)3, (int)((List)((Object)taskU3.getProperties().get(assocName))).size());
        ArrayList<NodeRef> toAddAgain = new ArrayList<NodeRef>();
        toAddAgain.add(new NodeRef("workspace://1/1004"));
        toAddAgain.add(new NodeRef("workspace://1/1005"));
        HashMap<QName, List<NodeRef>> addAssocsAgain = new HashMap<QName, List<NodeRef>>();
        addAssocsAgain.put(assocName, toAddAgain);
        WorkflowTask taskU4 = this.taskComponent.updateTask(task.getId(), null, addAssocsAgain, null);
        JBPMEngineTest.assertNotNull((Object)taskU4.getProperties().get(assocName));
        JBPMEngineTest.assertEquals((int)5, (int)((List)((Object)taskU4.getProperties().get(assocName))).size());
        ArrayList<NodeRef> toRemove = new ArrayList<NodeRef>();
        toRemove.add(new NodeRef("workspace://1/1002"));
        toRemove.add(new NodeRef("workspace://1/1003"));
        HashMap<QName, List<NodeRef>> removeAssocs = new HashMap<QName, List<NodeRef>>();
        removeAssocs.put(assocName, toRemove);
        WorkflowTask taskU5 = this.taskComponent.updateTask(task.getId(), null, null, removeAssocs);
        JBPMEngineTest.assertNotNull((Object)taskU5.getProperties().get(assocName));
        JBPMEngineTest.assertEquals((int)3, (int)((List)((Object)taskU5.getProperties().get(assocName))).size());
    }

    public void testGetWorkflowInstances() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        this.workflowComponent.startWorkflow(workflowDef.getId(), null);
        this.workflowComponent.startWorkflow(workflowDef.getId(), null);
        List<WorkflowInstance> instances = this.workflowComponent.getActiveWorkflows(workflowDef.getId());
        JBPMEngineTest.assertNotNull(instances);
        JBPMEngineTest.assertEquals((int)2, (int)instances.size());
        for (WorkflowInstance instance : instances) {
            JBPMEngineTest.assertEquals((String)workflowDef.getId(), (String)instance.getDefinition().getId());
        }
    }

    public void testGetPositions() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        this.workflowComponent.startWorkflow(workflowDef.getId(), null);
        List<WorkflowInstance> instances = this.workflowComponent.getActiveWorkflows(workflowDef.getId());
        JBPMEngineTest.assertNotNull(instances);
        JBPMEngineTest.assertEquals((int)1, (int)instances.size());
        List<WorkflowPath> paths = this.workflowComponent.getWorkflowPaths(instances.get(0).getId());
        JBPMEngineTest.assertNotNull(paths);
        JBPMEngineTest.assertEquals((int)1, (int)paths.size());
        JBPMEngineTest.assertEquals((String)instances.get(0).getId(), (String)paths.get(0).getInstance().getId());
        JBPMEngineTest.assertTrue((boolean)paths.get(0).getId().endsWith("-@"));
    }

    public void testCancelWorkflowInstance() throws Exception {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        this.workflowComponent.startWorkflow(workflowDef.getId(), null);
        List<WorkflowInstance> instances1 = this.workflowComponent.getActiveWorkflows(workflowDef.getId());
        JBPMEngineTest.assertNotNull(instances1);
        JBPMEngineTest.assertEquals((int)1, (int)instances1.size());
        List<WorkflowTask> tasks = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.IN_PROGRESS);
        JBPMEngineTest.assertNotNull(tasks);
        JBPMEngineTest.assertTrue((tasks.size() > 0 ? 1 : 0) != 0);
        WorkflowInstance cancelledInstance = this.workflowComponent.cancelWorkflow(instances1.get(0).getId());
        JBPMEngineTest.assertNotNull((Object)cancelledInstance);
        JBPMEngineTest.assertFalse((boolean)cancelledInstance.isActive());
        List<WorkflowInstance> instances2 = this.workflowComponent.getActiveWorkflows(workflowDef.getId());
        JBPMEngineTest.assertNotNull(instances2);
        JBPMEngineTest.assertEquals((int)0, (int)instances2.size());
        List<WorkflowTask> tasks1 = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.IN_PROGRESS);
        JBPMEngineTest.assertNotNull(tasks1);
        tasks1 = this.filterTasksByWorkflowInstance(tasks1, cancelledInstance.getId());
        JBPMEngineTest.assertEquals((int)0, (int)tasks1.size());
    }

    public void testCancelForEachFork() throws Exception {
        ClassPathResource processDef = new ClassPathResource("test/alfresco/parallel_loop_review_processdefinition.xml");
        WorkflowDeployment deployment = this.workflowComponent.deployDefinition(processDef.getInputStream(), "text/xml");
        WorkflowDefinition parallelDef = deployment.getDefinition();
        JBPMEngineTest.assertNotNull((Object)parallelDef);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER1);
        QName approvePercentName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"requiredApprovePercent");
        NodeRef pckgNode = this.packageComponent.createPackage(null);
        List<NodeRef> assignees = Arrays.asList(this.person1, this.person2, this.person3);
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(WorkflowModel.ASSOC_ASSIGNEES, (Serializable)((Object)assignees));
        parameters.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)pckgNode);
        parameters.put(approvePercentName, Float.valueOf(60.0f));
        WorkflowPath path = this.workflowComponent.startWorkflow(parallelDef.getId(), parameters);
        WorkflowTask startTask = this.workflowComponent.getTasksForWorkflowPath(path.getId()).get(0);
        this.taskComponent.endTask(startTask.getId(), null);
        this.checkInstanceExists(path.getInstance().getId(), parallelDef.getId(), true);
        this.ParallelReject(USER1);
        this.ParallelReject(USER2);
        this.ParallelReject(USER3);
        List<WorkflowTask> tasks = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        JBPMEngineTest.assertEquals((int)1, (int)tasks.size());
        this.taskComponent.endTask(tasks.get(0).getId(), "again");
        WorkflowInstance cancelledWf = this.workflowComponent.cancelWorkflow(path.getInstance().getId());
        this.checkInstanceExists(cancelledWf.getId(), parallelDef.getId(), false);
    }

    private void checkInstanceExists(String instanceId, String defId, boolean expected) {
        boolean match = false;
        List<WorkflowInstance> activeWfs = this.workflowComponent.getActiveWorkflows(defId);
        for (WorkflowInstance instance : activeWfs) {
            if (!instance.getId().equals(instanceId)) continue;
            match = true;
            break;
        }
        JBPMEngineTest.assertEquals((boolean)expected, (boolean)match);
    }

    private void ParallelReject(String user) {
        List<WorkflowTask> tasks = this.taskComponent.getAssignedTasks(user, WorkflowTaskState.IN_PROGRESS);
        JBPMEngineTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask task = tasks.get(0);
        this.taskComponent.endTask(task.getId(), "reject");
    }

    public void testSignal() {
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.rootNodeRef);
        WorkflowDefinition workflowDef = this.getTestDefinition();
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        WorkflowPath updatedPath = this.workflowComponent.signal(path.getId(), path.getNode().getTransitions()[1].getId());
        JBPMEngineTest.assertNotNull((Object)updatedPath);
    }

    public void testGetAssignedTasks() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"reviewer"), (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.rootNodeRef);
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"package"), (Serializable)this.packageComponent.createPackage(null));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        JBPMEngineTest.assertNotNull(tasks);
        JBPMEngineTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks.get(0).getId(), path.getNode().getTransitions()[0].getId());
        JBPMEngineTest.assertNotNull((Object)updatedTask);
        List<WorkflowTask> completedTasks = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.COMPLETED);
        JBPMEngineTest.assertNotNull(completedTasks);
        completedTasks = this.filterTasksByWorkflowInstance(completedTasks, path.getInstance().getId());
        JBPMEngineTest.assertEquals((int)1, (int)completedTasks.size());
        List<WorkflowTask> assignedTasks = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.IN_PROGRESS);
        JBPMEngineTest.assertNotNull(assignedTasks);
        assignedTasks = this.filterTasksByWorkflowInstance(assignedTasks, path.getInstance().getId());
        JBPMEngineTest.assertEquals((int)1, (int)assignedTasks.size());
        JBPMEngineTest.assertEquals((String)"review", (String)assignedTasks.get(0).getName());
    }

    public void xtestMultiAssign() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        ArrayList<String> bpm_assignees = new ArrayList<String>();
        bpm_assignees.add(AuthenticationUtil.getAdminUserName());
        bpm_assignees.add("bob");
        bpm_assignees.add("fred");
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"assignees"), bpm_assignees);
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.rootNodeRef);
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        JBPMEngineTest.assertNotNull(tasks);
        JBPMEngineTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks.get(0).getId(), "multi");
        JBPMEngineTest.assertNotNull((Object)updatedTask);
    }

    public void testEndTask() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"reviewer"), (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.rootNodeRef);
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"package"), (Serializable)this.packageComponent.createPackage(null));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.IN_PROGRESS), (Object)((Object)tasks1.get(0).getState()));
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks1.get(0).getId(), null);
        JBPMEngineTest.assertNotNull((Object)updatedTask);
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.COMPLETED), (Object)((Object)updatedTask.getState()));
        List<WorkflowTask> completedTasks = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.COMPLETED);
        JBPMEngineTest.assertNotNull(completedTasks);
        completedTasks = this.filterTasksByWorkflowInstance(completedTasks, path.getInstance().getId());
        JBPMEngineTest.assertEquals((int)1, (int)completedTasks.size());
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.COMPLETED), (Object)((Object)completedTasks.get(0).getState()));
    }

    public void testGetTask() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"reviewer"), (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.rootNodeRef);
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask getTask = this.taskComponent.getTaskById(tasks1.get(0).getId());
        JBPMEngineTest.assertNotNull((Object)getTask);
        JBPMEngineTest.assertEquals((String)getTask.getId(), (String)tasks1.get(0).getId());
    }

    public void testNodeRef() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"reviewer"), (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.rootNodeRef);
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"package"), (Serializable)this.packageComponent.createPackage(null));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.IN_PROGRESS), (Object)((Object)tasks1.get(0).getState()));
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks1.get(0).getId(), null);
        JBPMEngineTest.assertNotNull((Object)updatedTask);
    }

    public void testScript() throws IOException {
        ClassPathResource processDef = new ClassPathResource("jbpmresources/test_script.xml");
        JBPMEngineTest.assertFalse((boolean)this.workflowComponent.isDefinitionDeployed(processDef.getInputStream(), "text/xml"));
        WorkflowDeployment deployment = this.workflowComponent.deployDefinition(processDef.getInputStream(), "text/xml");
        JBPMEngineTest.assertNotNull((Object)deployment);
        WorkflowDefinition workflowDef = deployment.getDefinition();
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.rootNodeRef);
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"package"), (Serializable)this.packageComponent.createPackage(null));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.IN_PROGRESS), (Object)((Object)tasks1.get(0).getState()));
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks1.get(0).getId(), null);
        JBPMEngineTest.assertNotNull((Object)updatedTask);
    }

    public void testWorkflowDefinitionVisibility() {
        List<WorkflowDefinition> defs = this.workflowComponent.getDefinitions();
        List<WorkflowDefinition> allDefs = this.workflowComponent.getAllDefinitions();
        JBPMEngineTest.assertFalse((boolean)defs.isEmpty());
        JBPMEngineTest.assertFalse((boolean)allDefs.isEmpty());
    }

    private WorkflowDefinition getTestDefinition() {
        return this.testWorkflowDef;
    }

    private NodeRef createPerson(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap personProps = new PropertyMap();
            personProps.put(ContentModel.PROP_USERNAME, userName);
            return this.personService.createPerson(personProps);
        }
        return this.personService.getPerson(userName);
    }

    private List<WorkflowTask> filterTasksByWorkflowInstance(List<WorkflowTask> tasks, String workflowInstanceId) {
        ArrayList<WorkflowTask> filteredTasks = new ArrayList<WorkflowTask>();
        for (WorkflowTask task : tasks) {
            if (!task.getPath().getInstance().getId().equals(workflowInstanceId)) continue;
            filteredTasks.add(task);
        }
        return filteredTasks;
    }
}

