/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.jbpm.JBPMEngine;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.junit.AfterClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBPMJunit4LoadTests
extends BaseSpringTest {
    private static String WORKFLOW_NAME = "jbpm$wf:adhoc";
    private static String WORKFLOW_NODE_NAME = "workflow-test-19243cbb-c58a-485e-bcd9-2e2be030dfb9.txt";
    private static int WORKFLOW_COUNT = 2000;
    private static List<String> workflowIds = null;
    private static NodeRef rootNode = null;
    private ServiceRegistry serviceRegistry;
    private RetryingTransactionHelper retryingTransactionHelper;
    private static NodeService nodeService;
    private static WorkflowService workflowService;
    private FileFolderService fileFolderService;
    private Repository repositoryHelper;
    private JBPMEngine jbpmEngine;
    private NodeRef companyHomeNodeRef;

    public void onSetUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)this.getApplicationContext().getBean("ServiceRegistry");
        this.repositoryHelper = (Repository)this.getApplicationContext().getBean("repositoryHelper");
        this.jbpmEngine = (JBPMEngine)this.getApplicationContext().getBean("jbpm_engine");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.retryingTransactionHelper = this.serviceRegistry.getRetryingTransactionHelper();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        workflowService = this.serviceRegistry.getWorkflowService();
        nodeService = this.serviceRegistry.getNodeService();
        this.companyHomeNodeRef = this.repositoryHelper.getCompanyHome();
        System.out.println(" -------------- ");
        this.createWorkflowStuff();
    }

    public void createWorkflowStuff() throws Exception {
        System.out.println(" [createWorkflowStuff] Started at " + new Date().toString());
        if (rootNode == null) {
            workflowIds = new ArrayList<String>();
            RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    FileInfo rootInfo = JBPMJunit4LoadTests.this.fileFolderService.create(JBPMJunit4LoadTests.this.companyHomeNodeRef, WORKFLOW_NODE_NAME, ContentModel.TYPE_FOLDER);
                    rootNode = rootInfo.getNodeRef();
                    FileInfo contentInfo = JBPMJunit4LoadTests.this.fileFolderService.create(rootNode, WORKFLOW_NODE_NAME, ContentModel.TYPE_CONTENT);
                    NodeRef content = contentInfo.getNodeRef();
                    ContentService contentService = JBPMJunit4LoadTests.this.serviceRegistry.getContentService();
                    ContentWriter writer = contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.setEncoding("UTF-8");
                    writer.putContent("many workflows many workflows many workflows many workflows many workflows many workflows many workflows many workflows");
                    System.out.println(" [createWorkflowStuff] Workflow root node '" + WORKFLOW_NODE_NAME + "' has been created");
                    WorkflowDefinition wfDef = JBPMJunit4LoadTests.this.jbpmEngine.getDefinitionByName(WORKFLOW_NAME);
                    long startTime = new Date().getTime();
                    Integer i = 0;
                    while (i < WORKFLOW_COUNT) {
                        Map properties = JBPMJunit4LoadTests.this.prepareWorkflowProperties(rootNode, content, i.toString());
                        WorkflowPath path = workflowService.startWorkflow(wfDef.getId(), properties);
                        workflowIds.add(path.getInstance().getId());
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                    long endTime = new Date().getTime();
                    System.out.println(" [createWorkflowStuff] Execution time (ms): " + (endTime - startTime));
                    return null;
                }
            };
            this.retryingTransactionHelper.setMaxRetries(1);
            this.retryingTransactionHelper.doInTransaction(callback);
            System.out.println(" [createWorkflowStuff] Finished at " + new Date().toString());
        } else {
            System.out.println(" [createWorkflowStuff] Workflow node '" + WORKFLOW_NODE_NAME + "' already exists");
        }
    }

    @Test
    public void testGetAssignedTasks_NEW() throws Exception {
        int RUN_COUNT = 7;
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Date beginTime = new Date();
                System.out.println(" [testGetAssignedTasks_NEW] Started at " + beginTime.toString());
                List<WorkflowTask> tasks = workflowService.getAssignedTasks("admin", WorkflowTaskState.IN_PROGRESS);
                Date endTime = new Date();
                System.out.println(" [testGetAssignedTasks_NEW] Retrieved tasks: " + tasks.size() + " in " + (endTime.getTime() - beginTime.getTime()) + " ms");
                System.out.println(" [testGetAssignedTasks_NEW] Finished at " + endTime.toString());
                return null;
            }
        };
        this.retryingTransactionHelper.setMaxRetries(1);
        for (int i = 0; i < 7; ++i) {
            this.retryingTransactionHelper.doInTransaction(callback);
        }
    }

    public void onTearDown() throws Exception {
        System.out.println(" -------------- ");
    }

    private Map<QName, Serializable> prepareWorkflowProperties(NodeRef root, NodeRef content, String id) {
        NodeRef packageRef = this.makePackage(root, content, id);
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)packageRef);
        parameters.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)((Object)"admin"));
        parameters.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)("Test workflow '" + id + "'")));
        parameters.put(WorkflowModel.PROP_WORKFLOW_DEFINITION_NAME, (Serializable)((Object)("test_workflow_" + id)));
        return parameters;
    }

    private NodeRef makePackage(NodeRef root, NodeRef content, String id) {
        NodeRef container = this.fileFolderService.create(root, "package" + id, ContentModel.TYPE_FOLDER).getNodeRef();
        NodeRef packageRef = workflowService.createPackage(container);
        nodeService.addChild(packageRef, content, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"", (String)id));
        return packageRef;
    }

    @AfterClass
    public static void cleanup() {
        if (workflowIds != null) {
            for (String wfId : workflowIds) {
                try {
                    workflowService.cancelWorkflow(wfId);
                }
                catch (Exception exception) {}
            }
        }
        nodeService.deleteNode(rootNode);
    }
}

