/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.util.Collection;
import java.util.Map;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class JoinEndForkedTokens
implements ActionHandler {
    private static final long serialVersionUID = 8679390550752208189L;

    public void execute(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        Map childTokens = token.getActiveChildren();
        for (Object childToken : childTokens.values()) {
            this.cancelToken(executionContext, (Token)childToken);
        }
    }

    protected void cancelToken(ExecutionContext executionContext, Token token) {
        Map childTokens = token.getActiveChildren();
        for (Object childToken : childTokens.values()) {
            this.cancelToken(executionContext, (Token)childToken);
        }
        if (!token.hasEnded()) {
            token.end(false);
        }
        this.cancelTokenTasks(executionContext, token);
    }

    protected void cancelTokenTasks(ExecutionContext executionContext, Token token) {
        TaskMgmtInstance tms = executionContext.getTaskMgmtInstance();
        Collection tasks = tms.getUnfinishedTasks(token);
        for (TaskInstance task : tasks) {
            TaskInstance taskInstance = task;
            if (taskInstance.isBlocking()) {
                taskInstance.setBlocking(false);
            }
            if (taskInstance.isSignalling()) {
                taskInstance.setSignalling(false);
            }
            if (taskInstance.hasEnded()) continue;
            taskInstance.cancel();
        }
    }
}

