/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.jbpm.JBPMEngine;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.namespace.QName;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springmodules.workflow.jbpm31.JbpmFactoryLocator;

public class WorkflowTaskInstance
extends TaskInstance {
    private static final long serialVersionUID = 6824116036569411964L;
    private String jbpmEngineName = null;
    private static JBPMEngine jbpmEngine = null;

    public WorkflowTaskInstance() {
    }

    public WorkflowTaskInstance(String taskName, String actorId) {
        super(taskName, actorId);
    }

    public void setJbpmEngineName(String jbpmEngineName) {
        this.jbpmEngineName = jbpmEngineName;
    }

    private JBPMEngine getJBPMEngine() {
        if (jbpmEngine == null) {
            JbpmFactoryLocator factoryLocator = new JbpmFactoryLocator();
            BeanFactoryReference factory = factoryLocator.useBeanFactory(null);
            if (this.jbpmEngineName == null) {
                this.jbpmEngineName = "jbpm_engine";
            }
            if ((jbpmEngine = (JBPMEngine)factory.getFactory().getBean(this.jbpmEngineName)) == null) {
                throw new WorkflowException("Failed to retrieve JBPMEngine component");
            }
        }
        return jbpmEngine;
    }

    public void create(ExecutionContext executionContext) {
        super.create(executionContext);
        this.getJBPMEngine().setDefaultTaskProperties(this);
    }

    public void end(Transition transition) {
        Transition outcome;
        if (this.actorId == null) {
            this.actorId = AuthenticationUtil.getFullyAuthenticatedUser();
        }
        HashMap<QName, Serializable> taskProperties = new HashMap<QName, Serializable>();
        Transition transition2 = outcome = transition == null ? this.token.getNode().getDefaultLeavingTransition() : transition;
        if (outcome != null) {
            taskProperties.put(WorkflowModel.PROP_OUTCOME, (Serializable)((Object)outcome.getName()));
        }
        taskProperties.put(WorkflowModel.PROP_STATUS, (Serializable)((Object)"Completed"));
        this.getJBPMEngine().setTaskProperties(this, taskProperties);
        super.end(transition);
        if (this.getTask().getStartState() != null) {
            this.getJBPMEngine().setDefaultWorkflowProperties(this);
            this.getJBPMEngine().setDefaultStartTaskDescription(this);
        }
    }
}

