/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jscript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.jscript.ScriptableQNameMap;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.QName;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JscriptWorkflowTask
extends BaseScopableProcessorExtension
implements Serializable {
    static final long serialVersionUID = -8285971359421912313L;
    private final String id;
    private final String name;
    private final String title;
    private final String description;
    private ScriptableQNameMap<String, Serializable> properties;
    private boolean complete = false;
    private boolean pooled = false;
    private ServiceRegistry serviceRegistry;
    private ScriptableHashMap<String, String> transitions;
    private Scriptable packageResources;

    public JscriptWorkflowTask(String id, String name, String title, String description, ServiceRegistry serviceRegistry, ScriptableQNameMap<String, Serializable> properties, ScriptableHashMap<String, String> transitions, Scriptable packageResources, Scriptable scope) {
        this.id = id;
        this.name = name;
        this.title = title;
        this.description = description;
        this.serviceRegistry = serviceRegistry;
        this.properties = properties;
        this.transitions = transitions;
        this.packageResources = packageResources;
        this.setScope(scope);
    }

    public JscriptWorkflowTask(WorkflowTask cmrWorkflowTask, final ServiceRegistry serviceRegistry, Scriptable scope) {
        this.id = cmrWorkflowTask.getId();
        this.name = cmrWorkflowTask.getName();
        this.title = cmrWorkflowTask.getTitle();
        this.description = cmrWorkflowTask.getDescription();
        this.serviceRegistry = serviceRegistry;
        this.setScope(scope);
        this.properties = new ScriptableQNameMap(new NamespacePrefixResolverProvider(){
            private static final long serialVersionUID = 4218645978524914678L;

            public NamespacePrefixResolver getNamespacePrefixResolver() {
                return serviceRegistry.getNamespaceService();
            }
        });
        Set<QName> keys = cmrWorkflowTask.getProperties().keySet();
        for (QName key : keys) {
            Serializable value = cmrWorkflowTask.getProperties().get(key);
            this.properties.put(key.toString(), value);
        }
        this.transitions = new ScriptableHashMap();
        for (WorkflowTransition transition : cmrWorkflowTask.getPath().getNode().getTransitions()) {
            this.transitions.put(transition.getId(), transition.getTitle());
        }
        List<NodeRef> contents = serviceRegistry.getWorkflowService().getPackageContents(cmrWorkflowTask.getId());
        ArrayList<NodeRef> resources = new ArrayList<NodeRef>(contents.size());
        NodeService nodeService = serviceRegistry.getNodeService();
        DictionaryService ddService = serviceRegistry.getDictionaryService();
        for (NodeRef nodeRef : contents) {
            QName type;
            if (nodeRef.getStoreRef().getProtocol().equals("avm")) {
                resources.add(nodeRef);
                continue;
            }
            if (!nodeService.exists(nodeRef) || ddService.getType(type = nodeService.getType(nodeRef)) == null || !ddService.isSubClass(type, ContentModel.TYPE_CONTENT) && !ApplicationModel.TYPE_FILELINK.equals((Object)type)) continue;
            resources.add(nodeRef);
        }
        Object[] answer = new Object[resources.size()];
        for (int i = 0; i < resources.size(); ++i) {
            answer[i] = new ScriptNode((NodeRef)resources.get(i), serviceRegistry, this.getScope());
        }
        this.packageResources = Context.getCurrentContext().newArray(this.getScope(), answer);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Scriptable getProperties() {
        return this.properties;
    }

    public void setProperties(ScriptableQNameMap<String, Serializable> properties) {
        this.properties = properties;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isPooled() {
        return this.pooled;
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public void endTask(String transitionId) {
        this.serviceRegistry.getWorkflowService().endTask(this.id, transitionId);
    }

    public ScriptableHashMap<String, String> getTransitions() {
        return this.transitions;
    }

    public Scriptable getPackageResources() {
        return this.packageResources;
    }
}

