/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarEntryDTO
implements CalendarEntry,
Serializable {
    private static final long serialVersionUID = -7997650453677545845L;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private NodeRef nodeRef;
    private NodeRef containerNodeRef;
    private String systemName;
    private String title;
    private String description;
    private String location;
    private Date start;
    private Date end;
    private String recurrenceRule;
    private Date lastRecurrence;
    private String sharePointDocFolder;
    private boolean isOutlook = false;
    private String outlookUID;
    private Date createdAt;
    private Date modifiedAt;
    private List<String> tags = new ArrayList<String>();

    public CalendarEntryDTO() {
    }

    public CalendarEntryDTO(String title, String description, String location, Date start, Date end) {
        this.title = title;
        this.description = description;
        this.location = location;
        this.start = start;
        this.end = end;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public NodeRef getContainerNodeRef() {
        return this.containerNodeRef;
    }

    @Override
    public String getSystemName() {
        return this.systemName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public Date getStart() {
        return this.start;
    }

    @Override
    public void setStart(Date start) {
        this.start = start;
    }

    @Override
    public Date getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(Date end) {
        this.end = end;
    }

    @Override
    public String getRecurrenceRule() {
        return this.recurrenceRule;
    }

    @Override
    public void setRecurrenceRule(String recurrenceRule) {
        this.recurrenceRule = recurrenceRule;
    }

    @Override
    public Date getLastRecurrence() {
        return this.lastRecurrence;
    }

    @Override
    public void setLastRecurrence(Date lastRecurrence) {
        this.lastRecurrence = lastRecurrence;
    }

    @Override
    public boolean isOutlook() {
        return this.isOutlook;
    }

    @Override
    public void setOutlook(boolean outlook) {
        this.isOutlook = outlook;
    }

    @Override
    public String getOutlookUID() {
        return this.outlookUID;
    }

    @Override
    public void setOutlookUID(String outlookUID) {
        this.outlookUID = outlookUID;
    }

    @Override
    public String getSharePointDocFolder() {
        return this.sharePointDocFolder;
    }

    @Override
    public void setSharePointDocFolder(String docFolder) {
        this.sharePointDocFolder = docFolder;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Override
    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public static boolean isAllDay(CalendarEntry entry) {
        if (entry.getStart() == null || entry.getEnd() == null) {
            return false;
        }
        Calendar startUTC = Calendar.getInstance();
        Calendar endUTC = Calendar.getInstance();
        startUTC.setTime(entry.getStart());
        endUTC.setTime(entry.getEnd());
        startUTC.setTimeZone(UTC);
        endUTC.setTimeZone(UTC);
        Calendar startLocal = Calendar.getInstance();
        Calendar endLocal = Calendar.getInstance();
        startLocal.setTime(entry.getStart());
        endLocal.setTime(entry.getEnd());
        Calendar[] starts = new Calendar[]{startUTC, startLocal};
        Calendar[] ends = new Calendar[]{endUTC, endLocal};
        for (int i = 0; i < starts.length; ++i) {
            Calendar start = starts[i];
            Calendar end = ends[i];
            if (start.get(11) != 0 || start.get(12) != 0 || start.get(13) != 0 || end.get(11) != 0 || end.get(12) != 0 || end.get(13) != 0) continue;
            return true;
        }
        return false;
    }
}

