/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.util.HashMap;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransformationOptionLimitsTest {
    private TransformationOptionLimits limits;

    @Before
    public void setUp() throws Exception {
        this.limits = new TransformationOptionLimits();
    }

    @Test
    public void testTimeoutMs() throws Exception {
        long value = 1234L;
        this.limits.setTimeoutMs(value);
        long actual = this.limits.getTimeoutMs();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testReadLimitTimeMs() throws Exception {
        long value = 1234L;
        this.limits.setReadLimitTimeMs(value);
        long actual = this.limits.getReadLimitTimeMs();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testMaxSourceSizeKBytes() throws Exception {
        long value = 1234L;
        this.limits.setMaxSourceSizeKBytes(value);
        long actual = this.limits.getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testReadLimitKBytes() throws Exception {
        long value = 1234L;
        this.limits.setReadLimitKBytes(value);
        long actual = this.limits.getReadLimitKBytes();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testMaxPages() throws Exception {
        int value = 1234;
        this.limits.setMaxPages(value);
        int actual = this.limits.getMaxPages();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testPageLimit() throws Exception {
        int value = 1234;
        this.limits.setPageLimit(value);
        int actual = this.limits.getPageLimit();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testTimeException() throws Exception {
        String message = null;
        this.limits.setTimeoutMs(1L);
        try {
            this.limits.setReadLimitTimeMs(1L);
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
        }
        Assert.assertEquals((String)"Wrong exception message", (Object)"Both timeoutMs and readLimitTimeMs should not be set.", (Object)message);
    }

    @Test
    public void testKBytesException() throws Exception {
        String message = null;
        this.limits.setMaxSourceSizeKBytes(1L);
        try {
            this.limits.setReadLimitKBytes(1L);
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
        }
        Assert.assertEquals((String)"Wrong exception message", (Object)"Both maxSourceSizeKBytes and readLimitKBytes should not be set.", (Object)message);
    }

    @Test
    public void testPageException() throws Exception {
        String message = null;
        this.limits.setPageLimit(1);
        try {
            this.limits.setMaxPages(1);
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
        }
        Assert.assertEquals((String)"Wrong exception message", (Object)"Both maxPages and pageLimit should not be set.", (Object)message);
    }

    @Test
    public void testMapMax() throws Exception {
        this.limits.setTimeoutMs(123L);
        this.limits.setMaxSourceSizeKBytes(456L);
        this.limits.setMaxPages(789);
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        this.limits.toMap(optionsMap);
        TransformationOptionLimits actual = new TransformationOptionLimits();
        actual.set(optionsMap);
        Assert.assertEquals((String)"Did not match original values", (Object)this.limits, (Object)actual);
    }

    @Test
    public void testMapLimit() throws Exception {
        this.limits.setReadLimitTimeMs(123L);
        this.limits.setReadLimitKBytes(456L);
        this.limits.setPageLimit(789);
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        this.limits.toMap(optionsMap);
        TransformationOptionLimits actual = new TransformationOptionLimits();
        actual.set(optionsMap);
        Assert.assertEquals((String)"Did not match original values", (Object)this.limits, (Object)actual);
    }

    @Test
    public void testTimePair() throws Exception {
        int value = 1234;
        this.limits.setTimeoutMs(value);
        long actual = this.limits.getTimePair().getMax();
        Assert.assertEquals((String)"Returned TransformationOptionPair did not contain set value", (long)value, (long)actual);
    }

    @Test
    public void testKBytesPair() throws Exception {
        int value = 1234;
        this.limits.setMaxSourceSizeKBytes(value);
        long actual = this.limits.getKBytesPair().getMax();
        Assert.assertEquals((String)"Returned TransformationOptionPair did not contain set value", (long)value, (long)actual);
    }

    @Test
    public void testPagePair() throws Exception {
        int value = 1234;
        this.limits.setMaxPages(value);
        long actual = this.limits.getPagesPair().getMax();
        Assert.assertEquals((String)"Returned TransformationOptionPair did not contain set value", (long)value, (long)actual);
    }

    @Test
    public void testCombineOrder() throws Exception {
        this.limits.setReadLimitTimeMs(123L);
        this.limits.setReadLimitKBytes(45L);
        this.limits.setMaxPages(789);
        TransformationOptionLimits second = new TransformationOptionLimits();
        second.setReadLimitTimeMs(12L);
        second.setReadLimitKBytes(456L);
        second.setMaxPages(789);
        TransformationOptionLimits combined = this.limits.combine(second);
        TransformationOptionLimits combinedOtherWay = second.combine(this.limits);
        Assert.assertEquals((String)"The combine order should not matter", (Object)combined, (Object)combinedOtherWay);
    }

    @Test
    public void testCombine() throws Exception {
        this.limits.setReadLimitTimeMs(123L);
        this.limits.setReadLimitKBytes(45L);
        this.limits.setMaxPages(789);
        TransformationOptionLimits second = new TransformationOptionLimits();
        second.setTimeoutMs(12L);
        second.setMaxSourceSizeKBytes(456L);
        second.setMaxPages(789);
        TransformationOptionLimits combined = this.limits.combine(second);
        Assert.assertEquals((String)"Expected the lower value", (long)12L, (long)combined.getTimeoutMs());
        Assert.assertEquals((String)"Expected the lower value", (long)45L, (long)combined.getReadLimitKBytes());
        Assert.assertEquals((String)"Expected the lower value", (long)789L, (long)combined.getMaxPages());
    }

    @Test
    public void testCombineDynamic() throws Exception {
        this.limits.setReadLimitTimeMs(123L);
        this.limits.setReadLimitKBytes(45L);
        this.limits.setMaxPages(789);
        TransformationOptionLimits second = new TransformationOptionLimits();
        second.setReadLimitTimeMs(12L);
        second.setReadLimitKBytes(456L);
        second.setMaxPages(789);
        TransformationOptionLimits combined = this.limits.combine(second);
        this.limits.setReadLimitKBytes(4560L);
        Assert.assertEquals((String)"Expected the lower value", (long)456L, (long)combined.getReadLimitKBytes());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetTimeoutMs() throws Exception {
        TransformationOptionLimits combined = this.limits.combine(this.limits);
        combined.setTimeoutMs(1L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetReadLimitTimeMs() throws Exception {
        TransformationOptionLimits combined = this.limits.combine(this.limits);
        combined.setReadLimitTimeMs(1L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetMaxSourceSizeKBytes() throws Exception {
        TransformationOptionLimits combined = this.limits.combine(this.limits);
        combined.setMaxSourceSizeKBytes(1L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetReadLimitKBytes() throws Exception {
        TransformationOptionLimits combined = this.limits.combine(this.limits);
        combined.setReadLimitKBytes(1L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetMaxPages() throws Exception {
        TransformationOptionLimits combined = this.limits.combine(this.limits);
        combined.setMaxPages(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetPageLimit() throws Exception {
        TransformationOptionLimits combined = this.limits.combine(this.limits);
        combined.setPageLimit(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetMap() throws Exception {
        TransformationOptionLimits combined = this.limits.combine(this.limits);
        combined.set(null);
    }
}

