/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.IOException;
import java.util.Map;
import org.alfresco.repo.content.transform.TransformerDebug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationOptionPair {
    private long max = -1L;
    private long limit = -1L;

    public long getMax() {
        return this.max;
    }

    public void setMax(long max, String exceptionMessage) {
        if (max >= 0L && this.limit >= 0L) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        this.max = max;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit, String exceptionMessage) {
        if (this.max >= 0L && limit >= 0L) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        this.limit = limit;
    }

    public long getValue() {
        return this.minSet(this.getMax(), this.getLimit());
    }

    public Action getAction() {
        return this.getMax() >= 0L ? Action.THROW_EXCEPTION : (this.getLimit() >= 0L ? Action.RETURN_EOF : null);
    }

    private long minSet(long value1, long value2) {
        if (value1 < 0L) {
            return value2;
        }
        if (value2 < 0L) {
            return value1;
        }
        return Math.min(value1, value2);
    }

    public Map<String, Object> toMap(Map<String, Object> optionsMap, String optMaxKey, String optLimitKey) {
        optionsMap.put(optMaxKey, this.getMax());
        optionsMap.put(optLimitKey, this.getLimit());
        return optionsMap;
    }

    public void set(Map<String, Object> optionsMap, String optMaxKey, String optLimitKey, String exceptionMessage) {
        long max = this.nvl((Long)optionsMap.get(optMaxKey));
        long limit = this.nvl((Long)optionsMap.get(optLimitKey));
        if (max >= 0L && limit >= 0L) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (max >= 0L || limit >= 0L) {
            this.limit = limit;
            this.max = max;
        }
    }

    private long nvl(Long l) {
        return l == null ? -1L : l;
    }

    public TransformationOptionPair combine(final TransformationOptionPair that) {
        return new TransformationOptionPair(){

            @Override
            public long getMax() {
                long max = TransformationOptionPair.this.minSet(TransformationOptionPair.this.getMax(), that.getMax());
                long limit = TransformationOptionPair.this.minSet(TransformationOptionPair.this.getLimit(), that.getLimit());
                return max >= 0L && (limit < 0L || limit >= max) ? max : -1L;
            }

            @Override
            public void setMax(long max, String exceptionMessage) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getLimit() {
                long max = TransformationOptionPair.this.minSet(TransformationOptionPair.this.getMax(), that.getMax());
                long limit = TransformationOptionPair.this.minSet(TransformationOptionPair.this.getLimit(), that.getLimit());
                return limit >= 0L && (max < 0L || max >= limit) ? limit : -1L;
            }

            @Override
            public void setLimit(long limit, String exceptionMessage) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Map<String, Object> optionsMap, String optMaxKey, String optLimitKey, String exceptionMessage) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int hashCode() {
        return (int)(this.max > 0L ? this.max : this.limit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransformationOptionPair) {
            TransformationOptionPair that = (TransformationOptionPair)obj;
            return this.max == that.max && this.limit == that.limit;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        THROW_EXCEPTION{

            public void throwIOExceptionIfRequired(String message, TransformerDebug transformerDebug) throws IOException {
                throw transformerDebug.setCause(new IOException(message));
            }
        }
        ,
        RETURN_EOF{

            public void throwIOExceptionIfRequired(String message, TransformerDebug transformerDebug) throws IOException {
                if (transformerDebug.isEnabled()) {
                    transformerDebug.debug(message + " Returning EOF");
                }
            }
        };


        public abstract void throwIOExceptionIfRequired(String var1, TransformerDebug var2) throws IOException;
    }
}

