/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicallySizedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static Log logger = LogFactory.getLog(DynamicallySizedThreadPoolExecutor.class);
    private final ReentrantLock lock = new ReentrantLock();
    private int realCorePoolSize;

    public DynamicallySizedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        this.realCorePoolSize = corePoolSize;
    }

    public DynamicallySizedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.realCorePoolSize = corePoolSize;
    }

    public DynamicallySizedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.realCorePoolSize = corePoolSize;
    }

    public DynamicallySizedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.realCorePoolSize = corePoolSize;
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        this.realCorePoolSize = corePoolSize;
        super.setCorePoolSize(corePoolSize);
    }

    @Override
    public void execute(Runnable command) {
        int queueSize;
        int threadCount = this.getPoolSize();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Current pool size is " + threadCount + ", real core=" + this.realCorePoolSize + ", current core=" + this.getCorePoolSize() + ", max=" + this.getMaximumPoolSize()));
        }
        if (threadCount < this.getMaximumPoolSize() && (queueSize = this.getQueue().size() + 1) >= this.getMaximumPoolSize()) {
            this.lock.lock();
            int currentCoreSize = this.getCorePoolSize();
            if (currentCoreSize < this.getMaximumPoolSize()) {
                super.setCorePoolSize(currentCoreSize + 1);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Increased pool size to " + this.getCorePoolSize() + " from " + currentCoreSize + " due to queue size of " + queueSize));
                }
            }
            this.lock.unlock();
        }
        super.execute(command);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        int threadCount = this.getPoolSize();
        if (threadCount == this.getMaximumPoolSize() && threadCount > this.realCorePoolSize) {
            int queueSize = this.getQueue().size();
            int currentCoreSize = this.getCorePoolSize();
            if (queueSize < 2 && currentCoreSize > this.realCorePoolSize) {
                this.lock.lock();
                currentCoreSize = this.getCorePoolSize();
                if (currentCoreSize > this.realCorePoolSize) {
                    super.setCorePoolSize(currentCoreSize - 1);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Decreased pool size to " + this.getCorePoolSize() + " from " + currentCoreSize + " (real core size is " + this.realCorePoolSize + ") due to queue size of " + queueSize));
                    }
                }
                this.lock.unlock();
            }
        }
    }
}

