/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DefaultComparisonUtils;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Difference;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.hibernate.dialect.Dialect;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultComparisonUtilsTest {
    @Mock
    private Results differences;
    private DefaultComparisonUtils comparisonUtils;
    private DiffContext ctx;
    @Mock
    private Dialect dialect;

    @Before
    public void setUp() {
        this.comparisonUtils = new DefaultComparisonUtils();
        this.ctx = new DiffContext(this.dialect, this.differences, null, null);
    }

    @Test
    public void compareSimple() {
        this.comparisonUtils.compareSimple(this.prop(null), this.prop(null), this.ctx, Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.prop(null), this.prop(null), Result.Strength.ERROR);
        this.comparisonUtils.compareSimple(this.prop("not_null_string"), this.prop("not_null_string"), this.ctx, Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.prop("not_null_string"), this.prop("not_null_string"), Result.Strength.ERROR);
        this.comparisonUtils.compareSimple(this.prop("left"), this.prop("right"), this.ctx, Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, this.prop("left"), this.prop("right"), Result.Strength.ERROR);
        this.comparisonUtils.compareSimple(this.prop("left"), this.prop(null), this.ctx, Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, this.prop("left"), this.prop(null), Result.Strength.ERROR);
        this.comparisonUtils.compareSimple(this.prop(null), this.prop("right"), this.ctx, Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, this.prop(null), this.prop("right"), Result.Strength.ERROR);
    }

    public DbProperty prop(String propValue) {
        DbObjectWithCollection dbo = new DbObjectWithCollection("dbo", null);
        return this.dbPropForValue(dbo, "someProperty", propValue);
    }

    @Test
    public void compareCollections() {
        DatabaseObject db1 = new DatabaseObject("db1");
        DatabaseObject db2 = new DatabaseObject("db2");
        DatabaseObject db3 = new DatabaseObject("db3");
        DatabaseObject db4 = new DatabaseObject("db4");
        ArrayList left = new ArrayList();
        Collections.addAll(left, db1, db2, db4);
        ArrayList right = new ArrayList();
        Collections.addAll(right, db1, db3, db4);
        this.comparisonUtils.compareCollections(left, right, this.ctx, Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db1), new DbProperty(db1));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, new DbProperty(db2), null, Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, null, new DbProperty(db3), Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db4), new DbProperty(db4));
    }

    @Test
    public void compareCollectionsWithMultipleMatches() {
        DatabaseObject db2 = new DatabaseObject("db2");
        DatabaseObject db3 = new DatabaseObject("db3");
        DatabaseObject db4 = new DatabaseObject("db4");
        DatabaseObject db1 = new DatabaseObject("db1", db2, db3);
        ArrayList left = new ArrayList();
        Collections.addAll(left, db1, db4);
        ArrayList right = new ArrayList();
        Collections.addAll(right, db1, db2, db3);
        this.comparisonUtils.compareCollections(left, right, this.ctx, Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, new DbProperty(db4), null, Result.Strength.ERROR);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db1), new DbProperty(db1));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db1), new DbProperty(db2));
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty(db1), new DbProperty(db3));
    }

    @Test
    public void compareSimpleCollections() {
        ArrayList<Object> leftCollection = new ArrayList<Object>();
        leftCollection.add(123);
        leftCollection.add("both");
        ArrayList<Object> subCollectionLeft = new ArrayList<Object>();
        subCollectionLeft.add(3);
        subCollectionLeft.add("my string");
        subCollectionLeft.add(10);
        subCollectionLeft.add("another");
        leftCollection.add(subCollectionLeft);
        leftCollection.add(456);
        leftCollection.add("left only");
        DbObjectWithCollection leftDbObj = new DbObjectWithCollection("left", leftCollection);
        DbProperty leftCollProp = new DbProperty(leftDbObj, "collection");
        ArrayList<Object> rightCollection = new ArrayList<Object>();
        rightCollection.add(123);
        rightCollection.add(789);
        ArrayList subCollectionRight = new ArrayList(subCollectionLeft);
        rightCollection.add(subCollectionRight);
        rightCollection.add("right only");
        rightCollection.add("both");
        rightCollection.add("one more right only");
        DbObjectWithCollection rightDbObj = new DbObjectWithCollection("right", rightCollection);
        DbProperty rightCollProp = new DbProperty(rightDbObj, "collection");
        this.comparisonUtils.compareSimpleCollections(leftCollProp, rightCollProp, this.ctx, Result.Strength.WARN);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[0]", 123), this.dbPropForValue(rightDbObj, "collection[0]", 123), Result.Strength.WARN);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[1]", "both"), this.dbPropForValue(rightDbObj, "collection[4]", "both"), Result.Strength.WARN);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.IN_BOTH_NO_DIFFERENCE, this.dbPropForValue(leftDbObj, "collection[2]", subCollectionLeft), this.dbPropForValue(rightDbObj, "collection[2]", subCollectionRight), Result.Strength.WARN);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, this.dbPropForValue(leftDbObj, "collection[3]", 456), this.dbPropForValue(rightDbObj, "collection", rightCollection), Result.Strength.WARN);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_REFERENCE, this.dbPropForValue(leftDbObj, "collection[4]", "left only"), this.dbPropForValue(rightDbObj, "collection", rightCollection), Result.Strength.WARN);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, this.dbPropForValue(leftDbObj, "collection", leftCollection), this.dbPropForValue(rightDbObj, "collection[1]", 789), Result.Strength.WARN);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, this.dbPropForValue(leftDbObj, "collection", leftCollection), this.dbPropForValue(rightDbObj, "collection[3]", "right only"), Result.Strength.WARN);
        ((Results)Mockito.verify((Object)this.differences)).add(Difference.Where.ONLY_IN_TARGET, this.dbPropForValue(leftDbObj, "collection", leftCollection), this.dbPropForValue(rightDbObj, "collection[5]", "one more right only"), Result.Strength.WARN);
    }

    private DbProperty dbPropForValue(DbObject obj, String propName, Object propValue) {
        return new DbProperty(obj, propName, -1, true, propValue);
    }

    private List<DbObject> createMockDbObjects(int size) {
        ArrayList<DbObject> dbObjects = new ArrayList<DbObject>(size);
        for (int i = 0; i < size; ++i) {
            DbObject dbo = (DbObject)Mockito.mock(DbObject.class);
            Mockito.when((Object)dbo.toString()).thenReturn((Object)("Mock DbObject " + i));
            dbObjects.add(dbo);
        }
        return dbObjects;
    }

    public static class DatabaseObject
    extends AbstractDbObject {
        private DbObject[] equivalentObjects = new DbObject[0];

        public DatabaseObject(String name) {
            super(null, name);
        }

        public DatabaseObject(String name, DbObject ... equivalentObjects) {
            this(name);
            this.equivalentObjects = equivalentObjects;
        }

        public void accept(DbObjectVisitor visitor) {
            visitor.visit(this);
        }

        protected void doDiff(DbObject right, DiffContext ctx, Result.Strength strength) {
            DbProperty leftProp = new DbProperty(this);
            DbProperty rightProp = new DbProperty(right);
            ctx.getComparisonResults().add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, leftProp, rightProp);
        }

        public boolean sameAs(DbObject other) {
            for (DbObject o : this.equivalentObjects) {
                if (!other.equals(o)) continue;
                return true;
            }
            return super.sameAs(other);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DbObjectWithCollection
    extends AbstractDbObject {
        private Collection<Object> collection;

        public DbObjectWithCollection(String name, Collection<Object> collection) {
            super(null, name);
            this.collection = collection;
        }

        @Override
        public void accept(DbObjectVisitor visitor) {
        }

        public Collection<Object> getCollection() {
            return this.collection;
        }
    }
}

