/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Sequence;
import org.alfresco.util.schemacomp.model.Table;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.TypeNames;
import org.springframework.context.ApplicationContext;

public class ExportDb {
    private final Map<String, Integer> reverseTypeMap = new TreeMap<String, Integer>();
    private DataSource dataSource;
    private Schema schema;
    private Dialect dialect;
    private String namePrefix = "alf_";

    public ExportDb(ApplicationContext context) {
        this((DataSource)context.getBean("dataSource"), (Dialect)context.getBean("dialect"));
    }

    public ExportDb(DataSource dataSource, Dialect dialect) {
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.init();
    }

    private void init() {
        try {
            this.attemptInit();
        }
        catch (SecurityException error) {
            throw new RuntimeException("Unable to generate type map using hibernate.", error);
        }
        catch (IllegalArgumentException error) {
            throw new RuntimeException("Unable to generate type map using hibernate.", error);
        }
        catch (NoSuchFieldException error) {
            throw new RuntimeException("Unable to generate type map using hibernate.", error);
        }
        catch (IllegalAccessException error) {
            throw new RuntimeException("Unable to generate type map using hibernate.", error);
        }
    }

    private void attemptInit() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field typeNamesField = Dialect.class.getDeclaredField("typeNames");
        typeNamesField.setAccessible(true);
        TypeNames typeNames = (TypeNames)typeNamesField.get(this.dialect);
        Field defaultsField = TypeNames.class.getDeclaredField("defaults");
        defaultsField.setAccessible(true);
        Map forwardMap2 = (Map)defaultsField.get(typeNames);
        for (Map.Entry e : forwardMap2.entrySet()) {
            this.reverseTypeMap.put(((String)e.getValue()).toLowerCase(), (Integer)e.getKey());
        }
        Field weightedField = TypeNames.class.getDeclaredField("weighted");
        weightedField.setAccessible(true);
        Map forwardMap1 = (Map)weightedField.get(typeNames);
        for (Map.Entry e : forwardMap1.entrySet()) {
            for (String type : ((Map)e.getValue()).values()) {
                this.reverseTypeMap.put(type.toLowerCase(), (Integer)e.getKey());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        PropertyCheck.mandatory((Object)this, (String)"dataSource", (Object)this.dataSource);
        Connection connection = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                connection.setAutoCommit(false);
                this.execute(connection);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to execute export.", e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable e) {}
        if (connection == null) return;
        connection.close();
        return;
    }

    private void execute(Connection con) throws Exception {
        DatabaseMetaData dbmd = con.getMetaData();
        String schemaName = this.getSchemaName(dbmd);
        this.schema = new Schema(schemaName);
        ResultSet tables = dbmd.getTables(null, schemaName, this.namePrefixFilter(), new String[]{"TABLE", "VIEW", "SEQUENCE"});
        while (tables.next()) {
            String tableName = tables.getString("TABLE_NAME");
            if (tableName.startsWith("BIN$")) continue;
            if (tables.getString("TABLE_TYPE").equals("SEQUENCE")) {
                Sequence sequence = new Sequence(tableName);
                this.schema.add(sequence);
                continue;
            }
            Table table = new Table(tableName);
            this.schema.add(table);
            ResultSet columns = dbmd.getColumns(null, tables.getString("TABLE_SCHEM"), tableName, "%");
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                Column column = new Column(columnName);
                String dbType = columns.getString("TYPE_NAME");
                int colSize = columns.getInt("COLUMN_SIZE");
                int scale = columns.getInt("DECIMAL_DIGITS");
                int jdbcType = columns.getInt("DATA_TYPE");
                String type = this.generateType(dbType, colSize, scale, jdbcType);
                column.setType(type);
                String nullableString = columns.getString("IS_NULLABLE");
                column.setNullable(this.parseBoolean(nullableString));
                column.setOrder(columns.getInt("ORDINAL_POSITION"));
                try {
                    String autoIncString = columns.getString("IS_AUTOINCREMENT");
                    column.setAutoIncrement(this.parseBoolean(autoIncString));
                }
                catch (SQLException jtdsDoesNOtHAveIsUatoincrement) {
                    column.setAutoIncrement(dbType.endsWith("identity"));
                }
                column.setParent(table);
                table.getColumns().add(column);
            }
            columns.close();
            ResultSet primarykeycols = dbmd.getPrimaryKeys(null, tables.getString("TABLE_SCHEM"), tableName);
            AbstractDbObject pk = null;
            while (primarykeycols.next()) {
                if (pk == null) {
                    String pkName = primarykeycols.getString("PK_NAME");
                    pk = new PrimaryKey(pkName);
                }
                String columnName = primarykeycols.getString("COLUMN_NAME");
                ((PrimaryKey)pk).getColumnNames().add(columnName);
                int columnOrder = primarykeycols.getInt("KEY_SEQ");
                ((PrimaryKey)pk).getColumnOrders().add(columnOrder);
            }
            primarykeycols.close();
            if (pk != null) {
                pk.setParent(table);
                table.setPrimaryKey((PrimaryKey)pk);
            }
            ResultSet indexes = dbmd.getIndexInfo(null, tables.getString("TABLE_SCHEM"), tableName, false, true);
            String lastIndexName = "";
            Index index = null;
            while (indexes.next()) {
                String indexName = indexes.getString("INDEX_NAME");
                if (indexName == null || indexName.equals(table.getPrimaryKey().getName())) continue;
                if (!indexName.equals(lastIndexName)) {
                    index = new Index(indexName);
                    index.setUnique(!indexes.getBoolean("NON_UNIQUE"));
                    index.setParent(table);
                    table.getIndexes().add(index);
                    lastIndexName = indexName;
                }
                if (index == null) continue;
                String columnName = indexes.getString("COLUMN_NAME");
                index.getColumnNames().add(columnName);
            }
            indexes.close();
            ResultSet foreignkeys = dbmd.getImportedKeys(null, tables.getString("TABLE_SCHEM"), tableName);
            String lastKeyName = "";
            ForeignKey fk = null;
            while (foreignkeys.next()) {
                String keyName = foreignkeys.getString("FK_NAME");
                if (!keyName.equals(lastKeyName)) {
                    fk = new ForeignKey(keyName);
                    fk.setParent(table);
                    table.getForeignKeys().add(fk);
                    lastKeyName = keyName;
                }
                if (fk == null) continue;
                fk.setLocalColumn(foreignkeys.getString("FKCOLUMN_NAME"));
                fk.setTargetTable(foreignkeys.getString("PKTABLE_NAME"));
                fk.setTargetColumn(foreignkeys.getString("PKCOLUMN_NAME"));
            }
            foreignkeys.close();
        }
        tables.close();
    }

    private String getSchemaName(DatabaseMetaData dbmd) throws SQLException {
        String schemaName = null;
        ResultSet schemas = dbmd.getSchemas();
        while (schemas.next()) {
            String thisSchema = schemas.getString("TABLE_SCHEM");
            if (!thisSchema.equals(dbmd.getUserName()) && !thisSchema.equalsIgnoreCase("dbo")) continue;
            schemaName = thisSchema;
            break;
        }
        schemas.close();
        return schemaName;
    }

    private boolean parseBoolean(String nullableString) {
        if (nullableString.equals("NO")) {
            return false;
        }
        if (nullableString.equals("YES")) {
            return true;
        }
        throw new IllegalArgumentException("Unsupported term \"" + nullableString + "\", perhaps this database doesn't use YES/NO for booleans?");
    }

    protected String generateType(String dbTypeRaw, int size, int digits, int sqlType) throws IllegalArgumentException, IllegalAccessException {
        String dbType = dbTypeRaw.toLowerCase();
        String sizeType = dbType + "(" + size + ")";
        if (this.reverseTypeMap.containsKey(sizeType)) {
            return sizeType;
        }
        String precisionScaleType = dbType + "(" + size + ", " + digits + ")";
        if (this.reverseTypeMap.containsKey(precisionScaleType)) {
            return precisionScaleType;
        }
        for (String key : this.reverseTypeMap.keySet()) {
            String popKey = key.replaceAll("\\$p", String.valueOf(size));
            popKey = popKey.replaceAll("\\$s", String.valueOf(digits));
            if (!(popKey = popKey.replaceAll("\\$l", String.valueOf(size))).equals(precisionScaleType) && !popKey.equals(sizeType)) continue;
            return popKey;
        }
        return dbType;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    private String namePrefixFilter() {
        return this.namePrefix + "%";
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }
}

