/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.List;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.model.DbObject;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedundantDbObject
extends Result {
    private static final int SHOW_MAX_MATCHES = 3;
    private DbObject dbObject;
    private List<DbObject> matches;

    public RedundantDbObject(DbObject dbObject, List<DbObject> matches) {
        super(null);
        this.dbObject = dbObject;
        this.matches = matches;
    }

    @Override
    public String describe() {
        if (this.matches.size() > 3) {
            return I18NUtil.getMessage((String)"system.schema_comp.redundant_obj.many_matches", (Object[])new Object[]{this.matches.size(), this.dbObject, this.describeMatches(), this.matches.size() - 3});
        }
        return I18NUtil.getMessage((String)"system.schema_comp.redundant_obj", (Object[])new Object[]{this.matches.size(), this.dbObject, this.describeMatches()});
    }

    private String describeMatches() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.matches.size() && i < 3; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.matches.get(i));
        }
        return sb.toString();
    }

    public String toString() {
        return "RedundantDbObject [dbObject=" + this.dbObject + ", matches=" + this.matches + "]";
    }
}

