/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.Arrays;
import java.util.Iterator;
import org.alfresco.util.schemacomp.Difference;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.SchemaCompTestingUtils;
import org.alfresco.util.schemacomp.SchemaComparator;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Table;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQL5InnoDBDialect;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaComparatorTest {
    private SchemaComparator comparator;
    private Schema reference;
    private Schema target;
    private Dialect dialect;

    @Before
    public void setup() {
        this.reference = new Schema("schema");
        this.target = new Schema("schema");
        this.dialect = new MySQL5InnoDBDialect();
    }

    @Test
    public void canPerformDiff() {
        this.reference.add(new Table(this.reference, "tbl_no_diff", SchemaCompTestingUtils.columns("id NUMBER(10)", "nodeRef VARCHAR2(200)", "name VARCHAR2(150)"), SchemaCompTestingUtils.pk("pk_tbl_no_diff", "id"), SchemaCompTestingUtils.fkeys(SchemaCompTestingUtils.fk("fk_tbl_no_diff", "nodeRef", "node", "nodeRef")), SchemaCompTestingUtils.indexes("idx_node id nodeRef")));
        this.reference.add(SchemaCompTestingUtils.table("table_in_reference"));
        this.reference.add(new Table(this.reference, "tbl_has_diff_pk", SchemaCompTestingUtils.columns("id NUMBER(10)", "nodeRef VARCHAR2(200)"), SchemaCompTestingUtils.pk("pk_is_diff", "id"), SchemaCompTestingUtils.fkeys(new ForeignKey[0]), SchemaCompTestingUtils.indexes("idx_one id nodeRef", "idx_two id")));
        this.target.add(new Table(this.target, "tbl_no_diff", SchemaCompTestingUtils.columns("id NUMBER(10)", "nodeRef VARCHAR2(200)", "name VARCHAR2(150)"), SchemaCompTestingUtils.pk("pk_tbl_no_diff", "id"), SchemaCompTestingUtils.fkeys(SchemaCompTestingUtils.fk("fk_tbl_no_diff", "nodeRef", "node", "nodeRef")), SchemaCompTestingUtils.indexes("idx_node id nodeRef")));
        this.target.add(new Table(this.target, "tbl_has_diff_pk", SchemaCompTestingUtils.columns("id NUMBER(10)", "nodeRef VARCHAR2(200)"), SchemaCompTestingUtils.pk("pk_is_diff", "nodeRef"), SchemaCompTestingUtils.fkeys(new ForeignKey[0]), SchemaCompTestingUtils.indexes("idx_one id nodeRef", "idx_two [unique] id")));
        this.target.add(SchemaCompTestingUtils.table("table_in_target"));
        this.comparator = new SchemaComparator(this.reference, this.target, this.dialect);
        this.comparator.validateAndCompare();
        SchemaCompTestingUtils.dumpDiffs(this.comparator.getComparisonResults(), false);
        SchemaCompTestingUtils.dumpValidation(this.comparator.getComparisonResults());
        Results results = this.comparator.getComparisonResults();
        Iterator<Result> it = results.iterator();
        Difference diff = (Difference)it.next();
        Assert.assertEquals((Object)((Object)Difference.Where.ONLY_IN_REFERENCE), (Object)((Object)diff.getWhere()));
        Assert.assertEquals((Object)"schema.table_in_reference", (Object)diff.getLeft().getPath());
        Assert.assertEquals(null, (Object)diff.getRight());
        Assert.assertEquals(null, (Object)diff.getLeft().getPropertyName());
        Assert.assertEquals(null, (Object)diff.getLeft().getPropertyValue());
        diff = (Difference)it.next();
        Assert.assertEquals((Object)((Object)Difference.Where.ONLY_IN_REFERENCE), (Object)((Object)diff.getWhere()));
        Assert.assertEquals((Object)"schema.tbl_has_diff_pk.pk_is_diff.columnNames[0]", (Object)diff.getLeft().getPath());
        Assert.assertEquals((Object)"schema.tbl_has_diff_pk.pk_is_diff.columnNames", (Object)diff.getRight().getPath());
        Assert.assertEquals((Object)"columnNames[0]", (Object)diff.getLeft().getPropertyName());
        Assert.assertEquals((Object)"id", (Object)diff.getLeft().getPropertyValue());
        Assert.assertEquals((Object)"columnNames", (Object)diff.getRight().getPropertyName());
        Assert.assertEquals(Arrays.asList("nodeRef"), (Object)diff.getRight().getPropertyValue());
        diff = (Difference)it.next();
        Assert.assertEquals((Object)((Object)Difference.Where.ONLY_IN_TARGET), (Object)((Object)diff.getWhere()));
        Assert.assertEquals((Object)"schema.tbl_has_diff_pk.pk_is_diff.columnNames", (Object)diff.getLeft().getPath());
        Assert.assertEquals((Object)"schema.tbl_has_diff_pk.pk_is_diff.columnNames[0]", (Object)diff.getRight().getPath());
        Assert.assertEquals((Object)"columnNames", (Object)diff.getLeft().getPropertyName());
        Assert.assertEquals(Arrays.asList("id"), (Object)diff.getLeft().getPropertyValue());
        Assert.assertEquals((Object)"columnNames[0]", (Object)diff.getRight().getPropertyName());
        Assert.assertEquals((Object)"nodeRef", (Object)diff.getRight().getPropertyValue());
        diff = (Difference)it.next();
        Assert.assertEquals((Object)"schema.tbl_has_diff_pk.idx_two.unique", (Object)diff.getLeft().getPath());
        Assert.assertEquals((Object)"schema.tbl_has_diff_pk.idx_two.unique", (Object)diff.getRight().getPath());
        Assert.assertEquals((Object)"unique", (Object)diff.getLeft().getPropertyName());
        Assert.assertEquals((Object)false, (Object)diff.getLeft().getPropertyValue());
        Assert.assertEquals((Object)"unique", (Object)diff.getRight().getPropertyName());
        Assert.assertEquals((Object)true, (Object)diff.getRight().getPropertyValue());
        diff = (Difference)it.next();
        Assert.assertEquals((Object)((Object)Difference.Where.ONLY_IN_TARGET), (Object)((Object)diff.getWhere()));
        Assert.assertEquals((Object)"schema.table_in_target", (Object)diff.getRight().getPath());
        Assert.assertEquals(null, (Object)diff.getLeft());
        Assert.assertEquals(null, (Object)diff.getRight().getPropertyName());
        Assert.assertEquals(null, (Object)diff.getRight().getPropertyValue());
        Assert.assertFalse((String)"There should be no more differences", (boolean)it.hasNext());
    }
}

