/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.List;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DefaultComparisonUtils;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.RedundantDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.validator.DbValidator;

public class ValidatingVisitor
implements DbObjectVisitor {
    private DiffContext ctx;
    private ComparisonUtils comparisonUtils = new DefaultComparisonUtils();

    public ValidatingVisitor(DiffContext ctx) {
        this.ctx = ctx;
    }

    public void visit(DbObject referenceObj) {
        List<DbObject> matches = this.comparisonUtils.findEquivalentObjects(this.ctx.getTargetSchema(), referenceObj);
        if (matches.size() > 1) {
            this.ctx.getComparisonResults().add(new RedundantDbObject(referenceObj, matches));
        }
        for (DbValidator validator : referenceObj.getValidators()) {
            for (DbObject target : matches) {
                validator.validate(referenceObj, target, this.ctx);
            }
        }
    }

    public void setComparisonUtils(ComparisonUtils comparisonUtils) {
        this.comparisonUtils = comparisonUtils;
    }
}

