/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DefaultComparisonUtils;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.validator.DbValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDbObject
implements DbObject {
    private DbObject parent;
    private String name;
    private Result.Strength nameStrength = Result.Strength.ERROR;
    protected ComparisonUtils comparisonUtils = new DefaultComparisonUtils();
    private List<DbValidator> validators = new ArrayList<DbValidator>();

    public AbstractDbObject(DbObject parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Result.Strength getNameStrength() {
        return this.nameStrength;
    }

    public void setNameStrength(Result.Strength nameStrength) {
        this.nameStrength = nameStrength;
    }

    @Override
    public boolean sameAs(DbObject other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this.getName() != null && other != null && other.getName() != null) {
            boolean sameParent = false;
            if (this.getParent() == null && other.getParent() == null) {
                sameParent = true;
            } else if (this.getParent() != null && this.getParent().sameAs(other.getParent())) {
                sameParent = true;
            }
            return sameParent && this.getName().equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDbObject other = (AbstractDbObject)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append("[name=");
        if (this.getName() != null) {
            sb.append(this.getName());
        } else {
            sb.append("null");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void diff(DbObject right, DiffContext ctx, Result.Strength strength) {
        DbProperty leftNameProp = new DbProperty(this, "name");
        DbProperty rightNameProp = new DbProperty(right, "name");
        this.comparisonUtils.compareSimple(leftNameProp, rightNameProp, ctx, this.getNameStrength());
        this.doDiff(right, ctx, strength);
    }

    @Override
    public DbObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DbObject parent) {
        this.parent = parent;
    }

    protected void doDiff(DbObject right, DiffContext ctx, Result.Strength strength) {
    }

    public void setComparisonUtils(ComparisonUtils comparisonUtils) {
        this.comparisonUtils = comparisonUtils;
    }

    @Override
    public List<DbValidator> getValidators() {
        return this.validators;
    }

    @Override
    public void setValidators(List<DbValidator> validators) {
        this.validators = validators == null ? Collections.emptyList() : validators;
    }

    @Override
    public String getTypeName() {
        return this.getClass().getSimpleName().toLowerCase();
    }
}

