/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Table;

public class Column
extends AbstractDbObject {
    private String type;
    private boolean nullable;
    private boolean autoIncrement;
    private int order;

    public Column(String name) {
        super(null, name);
    }

    public Column(Table table, String name, String type, boolean nullable) {
        super(table, name);
        this.type = type;
        this.nullable = nullable;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.autoIncrement ? 1231 : 1237);
        result = 31 * result + (this.nullable ? 1231 : 1237);
        result = 31 * result + this.order;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        if (this.autoIncrement != other.autoIncrement) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    protected void doDiff(DbObject right, DiffContext ctx, Result.Strength strength) {
        DbProperty thisTypeProp = new DbProperty(this, "type");
        DbProperty thisNullableProp = new DbProperty(this, "nullable");
        DbProperty thisOrderProp = new DbProperty(this, "order");
        DbProperty thisAutoIncProp = new DbProperty(this, "autoIncrement");
        Column thatColumn = (Column)right;
        DbProperty thatTypeProp = new DbProperty(thatColumn, "type");
        DbProperty thatNullableProp = new DbProperty(thatColumn, "nullable");
        DbProperty thatOrderProp = new DbProperty(thatColumn, "order");
        DbProperty thatAutoIncProp = new DbProperty(thatColumn, "autoIncrement");
        this.comparisonUtils.compareSimple(thisTypeProp, thatTypeProp, ctx);
        this.comparisonUtils.compareSimple(thisNullableProp, thatNullableProp, ctx);
        this.comparisonUtils.compareSimple(thisOrderProp, thatOrderProp, ctx);
        this.comparisonUtils.compareSimple(thisAutoIncProp, thatAutoIncProp, ctx);
    }

    public void accept(DbObjectVisitor visitor) {
        visitor.visit(this);
    }

    public boolean sameAs(DbObject other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass().equals(other.getClass()) && this.getName() != null && other.getName() != null && this.getParent() != null && other.getParent() != null && this.getParent().sameAs(other.getParent())) {
            return this.getName().equals(other.getName());
        }
        return false;
    }
}

