/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.hibernate.dialect.Dialect;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public abstract class DbObjectTestBase<T extends AbstractDbObject> {
    @Mock
    protected Dialect dialect;
    @Mock
    protected Results differences;
    protected DiffContext ctx;
    @Mock
    protected ComparisonUtils comparisonUtils;
    protected InOrder inOrder;
    @Mock
    protected DbObjectVisitor visitor;

    protected abstract T getThisObject();

    protected abstract T getThatObject();

    @Before
    public final void baseSetUp() {
        List<Object> mocks = this.getMocksUsedInDiff();
        this.inOrder = Mockito.inOrder((Object[])mocks.toArray());
        this.ctx = new DiffContext(this.dialect, this.differences, null, null);
    }

    protected List<Object> getMocksUsedInDiff() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(this.differences);
        objects.add(this.comparisonUtils);
        return objects;
    }

    @Test
    public void canDiffObjects() {
        T thisObject = this.getThisObject();
        ((AbstractDbObject)thisObject).setComparisonUtils(this.comparisonUtils);
        T thatObject = this.getThatObject();
        ((AbstractDbObject)thatObject).setComparisonUtils(this.comparisonUtils);
        ((AbstractDbObject)thisObject).diff((DbObject)thatObject, this.ctx, Result.Strength.ERROR);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty((DbObject)thisObject, "name"), new DbProperty((DbObject)thatObject, "name"), this.ctx, ((AbstractDbObject)thisObject).getNameStrength());
        this.doDiffTests();
    }

    protected abstract void doDiffTests();
}

