/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyTest
extends DbObjectTestBase<ForeignKey> {
    private ForeignKey thisFK;
    private ForeignKey thatFK;

    @Before
    public void setUp() throws Exception {
        this.thisFK = new ForeignKey(null, "this_fk", "local_col", "target_table", "target_col");
        this.thatFK = new ForeignKey(null, "that_fk", "local_col", "target_table", "target_col");
    }

    @Override
    protected ForeignKey getThisObject() {
        return this.thisFK;
    }

    @Override
    protected ForeignKey getThatObject() {
        return this.thatFK;
    }

    @Override
    protected void doDiffTests() {
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty(this.thisFK, "localColumn"), new DbProperty(this.thatFK, "localColumn"), this.ctx);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty(this.thisFK, "targetTable"), new DbProperty(this.thatFK, "targetTable"), this.ctx);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty(this.thisFK, "targetColumn"), new DbProperty(this.thatFK, "targetColumn"), this.ctx);
    }

    @Test
    public void acceptVisitor() {
        this.thisFK.accept(this.visitor);
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit(this.thisFK);
    }
}

