/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKey
extends AbstractDbObject {
    private final List<String> columnNames = new ArrayList<String>();
    private final List<Integer> columnOrders = new ArrayList<Integer>();

    public PrimaryKey(String name) {
        super(null, name);
    }

    public PrimaryKey(Table table, String name, List<String> columnNames, List<Integer> columnOrders) {
        super(table, name);
        this.columnNames.addAll(columnNames);
        this.columnOrders.addAll(columnOrders);
        this.checkColumnOrders();
    }

    private void checkColumnOrders() {
        if (this.columnOrders.size() > 0 && this.columnOrders.size() != this.columnNames.size()) {
            throw new IllegalArgumentException("columnOrders size does not match columnNames");
        }
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames.clear();
        this.columnNames.addAll(columnNames);
    }

    public List<Integer> getColumnOrders() {
        return this.columnOrders;
    }

    public void setColumnOrders(List<Integer> columnOrders) {
        this.columnOrders.clear();
        this.columnOrders.addAll(columnOrders);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.columnNames == null ? 0 : ((Object)this.columnNames).hashCode());
        result = 31 * result + (this.columnOrders == null ? 0 : ((Object)this.columnOrders).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrimaryKey other = (PrimaryKey)obj;
        if (this.columnNames == null ? other.columnNames != null : !((Object)this.columnNames).equals(other.columnNames)) {
            return false;
        }
        return !(this.columnOrders == null ? other.columnOrders != null : !((Object)this.columnOrders).equals(other.columnOrders));
    }

    @Override
    protected void doDiff(DbObject right, DiffContext ctx, Result.Strength strength) {
        this.checkColumnOrders();
        PrimaryKey rightPK = (PrimaryKey)right;
        this.comparisonUtils.compareSimpleCollections(new DbProperty(this, "columnNames"), new DbProperty(rightPK, "columnNames"), ctx, strength);
        this.comparisonUtils.compareSimpleCollections(new DbProperty(this, "columnOrders"), new DbProperty(rightPK, "columnOrders"), ctx, strength);
    }

    @Override
    public void accept(DbObjectVisitor visitor) {
        this.checkColumnOrders();
        visitor.visit(this);
    }

    @Override
    public String getTypeName() {
        return "primary key";
    }
}

