/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.Arrays;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKeyTest
extends DbObjectTestBase<PrimaryKey> {
    private PrimaryKey thisPK;
    private PrimaryKey thatPK;

    @Before
    public void setUp() {
        this.thisPK = new PrimaryKey(null, "this_pk", Arrays.asList("id", "name", "age"), Arrays.asList(2, 1, 3));
        this.thatPK = new PrimaryKey(null, "that_pk", Arrays.asList("a", "b"), Arrays.asList(1, 2));
    }

    @Override
    protected PrimaryKey getThisObject() {
        return this.thisPK;
    }

    @Override
    protected PrimaryKey getThatObject() {
        return this.thatPK;
    }

    @Override
    protected void doDiffTests() {
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimpleCollections(new DbProperty(this.thisPK, "columnNames"), new DbProperty(this.thatPK, "columnNames"), this.ctx, Result.Strength.ERROR);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimpleCollections(new DbProperty(this.thisPK, "columnOrders"), new DbProperty(this.thatPK, "columnOrders"), this.ctx, Result.Strength.ERROR);
    }

    @Test
    public void acceptVisitor() {
        this.thisPK.accept(this.visitor);
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit(this.thisPK);
    }
}

