/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.Schema;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class SchemaTest
extends DbObjectTestBase<Schema> {
    private Schema left;
    private Schema right;

    @Before
    public void setUp() {
        this.left = new Schema("left_schema");
        this.right = new Schema("right_schema");
    }

    @Override
    protected Schema getThisObject() {
        return this.left;
    }

    @Override
    protected Schema getThatObject() {
        return this.right;
    }

    @Override
    protected void doDiffTests() {
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareCollections(this.left.objects, this.right.objects, this.ctx);
    }

    @Test
    public void acceptVisitor() {
        DbObject dbo1 = (DbObject)Mockito.mock(DbObject.class);
        this.left.add(dbo1);
        DbObject dbo2 = (DbObject)Mockito.mock(DbObject.class);
        this.left.add(dbo2);
        DbObject dbo3 = (DbObject)Mockito.mock(DbObject.class);
        this.left.add(dbo3);
        this.left.accept(this.visitor);
        ((DbObject)Mockito.verify((Object)dbo1)).accept(this.visitor);
        ((DbObject)Mockito.verify((Object)dbo2)).accept(this.visitor);
        ((DbObject)Mockito.verify((Object)dbo3)).accept(this.visitor);
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit(this.left);
    }
}

