/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.test.exportdb;

import java.util.Iterator;
import org.alfresco.util.schemacomp.ExportDb;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Sequence;
import org.alfresco.util.schemacomp.model.Table;
import org.alfresco.util.schemacomp.test.exportdb.AbstractExportTester;
import org.junit.Assert;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class PostgreSQLDialectExportTester
extends AbstractExportTester {
    public PostgreSQLDialectExportTester(ExportDb exporter, PlatformTransactionManager tx, SimpleJdbcTemplate jdbcTemplate) {
        super(exporter, tx, jdbcTemplate);
    }

    protected void doExportTest() throws Exception {
        Schema schema = this.getSchema();
        Table exampleTable = null;
        Table otherTable = null;
        Sequence exampleSeq = null;
        for (DbObject dbo : schema) {
            if (dbo.getName().equals("export_test_example")) {
                exampleTable = (Table)dbo;
            }
            if (dbo.getName().equals("export_test_other")) {
                otherTable = (Table)dbo;
            }
            if (!dbo.getName().equals("export_test_example_seq")) continue;
            exampleSeq = (Sequence)dbo;
        }
        this.checkExampleTable(schema, exampleTable);
        this.checkOtherTable(schema, otherTable);
        this.checkExampleSequence(schema, exampleSeq);
    }

    private void checkOtherTable(Schema schema, Table otherTable) {
        Assert.assertNotNull((String)"Couldn't find table export_test_other", (Object)otherTable);
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)schema, (Object)otherTable.getParent());
        Iterator<Column> colIt = otherTable.getColumns().iterator();
        Column col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertEquals((Object)"id", (Object)col.getName());
        Assert.assertEquals((Object)"int8", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)1L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertEquals((Object)"version", (Object)col.getName());
        Assert.assertEquals((Object)"int8", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)2L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertEquals((Object)"ex_id", (Object)col.getName());
        Assert.assertEquals((Object)"int8", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)3L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertEquals((Object)"local_name", (Object)col.getName());
        Assert.assertEquals((Object)"varchar(200)", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)4L, (long)col.getOrder());
        Assert.assertEquals((long)2L, (long)otherTable.getIndexes().size());
        Iterator<Index> indexIt = otherTable.getIndexes().iterator();
        Index index = indexIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)index.getParent());
        Assert.assertEquals((Object)"export_test_idx_other_1", (Object)index.getName());
        Assert.assertEquals((Object)true, (Object)index.isUnique());
        Assert.assertEquals((long)2L, (long)index.getColumnNames().size());
        Assert.assertEquals((Object)"ex_id", (Object)index.getColumnNames().get(0));
        Assert.assertEquals((Object)"local_name", (Object)index.getColumnNames().get(1));
        index = indexIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)index.getParent());
        Assert.assertEquals((Object)"export_test_idx_other_2", (Object)index.getName());
        Assert.assertEquals((long)1L, (long)index.getColumnNames().size());
        Assert.assertEquals((Object)"ex_id", (Object)index.getColumnNames().get(0));
        PrimaryKey pk = otherTable.getPrimaryKey();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)pk.getParent());
        Assert.assertEquals((Object)"id", (Object)pk.getColumnNames().get(0));
        Assert.assertEquals((long)1L, (long)pk.getColumnOrders().get(0).intValue());
        Assert.assertEquals((long)1L, (long)otherTable.getForeignKeys().size());
        ForeignKey fk = otherTable.getForeignKeys().get(0);
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)fk.getParent());
        Assert.assertEquals((Object)"export_test_fk_example", (Object)fk.getName());
        Assert.assertEquals((Object)"ex_id", (Object)fk.getLocalColumn());
        Assert.assertEquals((Object)"export_test_example", (Object)fk.getTargetTable());
        Assert.assertEquals((Object)"id", (Object)fk.getTargetColumn());
    }

    private void checkExampleTable(Schema schema, Table exampleTable) {
        Assert.assertNotNull((String)"Couldn't find export_test_example", (Object)exampleTable);
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)schema, (Object)exampleTable.getParent());
        Assert.assertEquals((Object)"export_test_example", (Object)exampleTable.getName());
        Iterator<Column> colIt = exampleTable.getColumns().iterator();
        Column col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"id", (Object)col.getName());
        Assert.assertEquals((Object)"int8", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)1L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"description", (Object)col.getName());
        Assert.assertEquals((Object)"varchar(1024)", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)2L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"fixes_from_schema", (Object)col.getName());
        Assert.assertEquals((Object)"int4", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)3L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"fixes_to_schema", (Object)col.getName());
        Assert.assertEquals((Object)"int4", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)4L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"applied_to_schema", (Object)col.getName());
        Assert.assertEquals((Object)"int4", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)5L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"target_schema", (Object)col.getName());
        Assert.assertEquals((Object)"int4", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)6L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"applied_on_date", (Object)col.getName());
        Assert.assertEquals((Object)"timestamp", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)7L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"applied_to_server", (Object)col.getName());
        Assert.assertEquals((Object)"varchar(64)", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)8L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"was_executed", (Object)col.getName());
        Assert.assertEquals((Object)"bool", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)9L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"succeeded", (Object)col.getName());
        Assert.assertEquals((Object)"bool", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)10L, (long)col.getOrder());
        col = colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"report", (Object)col.getName());
        Assert.assertEquals((Object)"varchar(1024)", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)11L, (long)col.getOrder());
        PrimaryKey pk = exampleTable.getPrimaryKey();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)pk.getParent());
        Assert.assertEquals((Object)"id", (Object)pk.getColumnNames().get(0));
        Assert.assertEquals((long)1L, (long)pk.getColumnOrders().get(0).intValue());
    }

    public void checkExampleSequence(Schema schema, Sequence seq) {
        Assert.assertNotNull((String)"Couldn't find sequence", (Object)seq);
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)schema, (Object)seq.getParent());
        Assert.assertEquals((Object)"export_test_example_seq", (Object)seq.getName());
    }

    protected void doDatabaseSetup() {
        final String[] createStatements = new String[]{"DROP TABLE IF EXISTS export_test_example CASCADE", "CREATE TABLE export_test_example             (                 id INT8 NOT NULL,                 description VARCHAR(1024),                 fixes_from_schema INT4,                 fixes_to_schema INT4,                 applied_to_schema INT4,                 target_schema INT4,                 applied_on_date TIMESTAMP,                 applied_to_server VARCHAR(64),                 was_executed BOOL,                 succeeded BOOL,                 report VARCHAR(1024),                 PRIMARY KEY (id)             )", "DROP TABLE IF EXISTS export_test_other CASCADE", "CREATE TABLE export_test_other            (                id INT8 NOT NULL,                version INT8 NOT NULL,                ex_id INT8 NOT NULL,                local_name VARCHAR(200) NOT NULL,                CONSTRAINT export_test_fk_example FOREIGN KEY (ex_id) REFERENCES export_test_example (id),                PRIMARY KEY (id)            )", "DROP INDEX IF EXISTS export_test_idx_other_1", "CREATE UNIQUE INDEX export_test_idx_other_1 ON export_test_other (ex_id, local_name)", "DROP INDEX IF EXISTS export_test_idx_other_2", "CREATE INDEX export_test_idx_other_2 ON export_test_other (ex_id)", "DROP SEQUENCE IF EXISTS export_test_example_seq", "CREATE SEQUENCE export_test_example_seq START WITH 1 INCREMENT BY 1"};
        TransactionTemplate tt = new TransactionTemplate(this.tx);
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                for (String sql : createStatements) {
                    PostgreSQLDialectExportTester.this.jdbcTemplate.update(sql, new Object[0]);
                }
            }
        });
    }
}

