/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.validator;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.ValidationResult;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.validator.DbValidator;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameValidator
implements DbValidator {
    private Pattern pattern;

    @Override
    public void validate(DbObject reference, DbObject target, DiffContext ctx) {
        String name = target.getName();
        if (this.pattern != null && !this.pattern.matcher(name).matches()) {
            String message = I18NUtil.getMessage((String)"system.schema_comp.name_validator", (Object[])new Object[]{this.pattern});
            ValidationResult result = new ValidationResult(new DbProperty(target, "name"), message);
            ctx.getComparisonResults().add(result);
        }
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public void setProperty(String name, String value) {
        if (name.equals("pattern") && value != null) {
            Pattern pattern = Pattern.compile(value);
            this.setPattern(pattern);
        }
    }

    @Override
    public String getProperty(String name) {
        if (name.equals("pattern") && this.pattern != null) {
            return this.pattern.toString();
        }
        return null;
    }

    @Override
    public Set<String> getPropertyNames() {
        TreeSet<String> props = new TreeSet<String>();
        props.add("pattern");
        return props;
    }
}

