/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.wcm.AbstractWCMServiceImplTest;
import org.alfresco.wcm.asset.AssetService;
import org.alfresco.wcm.sandbox.SandboxService;

public class WCMConcurrentTest
extends AbstractWCMServiceImplTest {
    private SandboxService sbService;
    private AssetService assetService;
    private static final String ADMIN = "admin";
    private static final String WP;
    private static final String SB_STG;
    private static final String SB_ADMIN;
    private static final String AVM_WEBAPPS_PATH = "www/avm_webapps";
    private static final String ROOT_PATH = "www/avm_webapps/ROOT";

    protected void setUp() throws Exception {
        super.setUp();
        this.sbService = (SandboxService)ctx.getBean("SandboxService");
        this.assetService = (AssetService)ctx.getBean("AssetService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ETWOTWO_1224() throws Exception {
        try {
            int i;
            AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN);
            this.wpService.createWebProject(WP, WP, "title", "description");
            WCMConcurrentTest.assertEquals((int)1, (int)this.wpService.listWebApps(WP).size());
            WCMConcurrentTest.assertEquals((int)0, (int)this.assetService.listAssets(SB_STG, ROOT_PATH, false).size());
            WCMConcurrentTest.assertEquals((int)0, (int)this.assetService.listAssets(SB_ADMIN, ROOT_PATH, false).size());
            long start = System.currentTimeMillis();
            logger.debug((Object)"Bulk import started ...");
            int listingRepeat = 100;
            String testFile = System.getProperty("user.dir") + "/source/test-resources/wcm/small-61-items.zip";
            File zipFile = new File(testFile);
            this.assetService.bulkImport(SB_ADMIN, ROOT_PATH, zipFile, false);
            int itemCount = this.assetService.listAssets(SB_ADMIN, ROOT_PATH, false).size();
            logger.debug((Object)("Items below ROOT: " + itemCount));
            assert (itemCount > 0);
            logger.debug((Object)("... bulk import finished in " + (System.currentTimeMillis() - start) + " msecs"));
            WCMConcurrentTest.assertEquals((int)0, (int)this.assetService.listAssets(SB_STG, ROOT_PATH, false).size());
            WCMConcurrentTest.assertEquals((int)itemCount, (int)this.assetService.listAssets(SB_ADMIN, ROOT_PATH, false).size());
            UserTransaction tx = this.transactionService.getUserTransaction();
            tx.begin();
            start = System.currentTimeMillis();
            logger.debug((Object)"Submit initiation started ...");
            this.sbService.submitAll(SB_ADMIN, "s1", "s1");
            tx.commit();
            logger.debug((Object)("... submit initiation finished in " + (System.currentTimeMillis() - start) + " msecs"));
            int threadCount = 1;
            Thread[] threads = new Thread[threadCount];
            WCMConcurrentTestListing[] listings = new WCMConcurrentTestListing[threadCount];
            for (i = 0; i < threadCount; ++i) {
                WCMConcurrentTestListing listing;
                listings[i] = listing = new WCMConcurrentTestListing(i, listingRepeat);
                threads[i] = new Thread(listing);
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                try {
                    threads[i].join();
                    if (listings[i].getErrorStackTrace() == null) continue;
                    throw new RuntimeException(listings[i].getErrorStackTrace());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            WCMConcurrentTest.assertEquals((int)1, (int)this.wpService.listWebApps(WP).size());
            WCMConcurrentTest.assertEquals((int)itemCount, (int)this.assetService.listAssets(SB_STG, ROOT_PATH, false).size());
            WCMConcurrentTest.assertEquals((int)itemCount, (int)this.assetService.listAssets(SB_ADMIN, ROOT_PATH, false).size());
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            AuthenticationUtil.clearCurrentSecurityContext();
            throw throwable;
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    static {
        SB_STG = WP = TEST_WEBPROJ_DNS;
        SB_ADMIN = WP + "--" + ADMIN;
    }

    private class WCMConcurrentTestListing
    implements Runnable {
        private int id;
        private int repeat;
        private String errorStackTrace = null;

        public WCMConcurrentTestListing(int id, int repeat) {
            this.id = id;
            this.repeat = repeat;
        }

        public String getErrorStackTrace() {
            return this.errorStackTrace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            UserTransaction tx = null;
            try {
                try {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)WCMConcurrentTest.ADMIN);
                    long start = System.currentTimeMillis();
                    for (int i = 1; i <= this.repeat; ++i) {
                        tx = WCMConcurrentTest.this.transactionService.getUserTransaction();
                        try {
                            tx.begin();
                            AbstractWCMServiceImplTest.logger.debug((Object)("Start: id: " + this.id + " - loop=" + i + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                            Assert.assertEquals((int)1, (int)WCMConcurrentTest.this.wpService.listWebApps(WP).size());
                            Thread.sleep(500L);
                            AbstractWCMServiceImplTest.logger.debug((Object)("Finish: id: " + this.id + " - loop=" + i + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                            tx.commit();
                            continue;
                        }
                        catch (Throwable t) {
                            if (this.errorStackTrace == null) {
                                StringWriter sw = new StringWriter();
                                t.printStackTrace(new PrintWriter(sw));
                                this.errorStackTrace = sw.toString();
                            }
                            System.err.println("Failed: id: " + this.id + " - loop=" + i + " [" + AlfrescoTransactionSupport.getTransactionId() + "] " + t.getMessage());
                            if (tx == null) continue;
                            try {
                                tx.rollback();
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    AbstractWCMServiceImplTest.logger.debug((Object)("id: " + this.id + " finished (repeated " + this.repeat + " times) in " + (System.currentTimeMillis() - start) + " msecs"));
                }
                catch (Throwable t) {
                    AbstractWCMServiceImplTest.logger.debug((Object)t.getMessage());
                    if (tx != null) {
                        try {
                            tx.rollback();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    this.errorStackTrace = sw.toString();
                    Object var8_9 = null;
                    AuthenticationUtil.clearCurrentSecurityContext();
                    return;
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                AuthenticationUtil.clearCurrentSecurityContext();
                throw throwable;
            }
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }
}

