/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.preview;

import java.text.MessageFormat;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.wcm.preview.AbstractPreviewURIServiceProvider;
import org.alfresco.wcm.preview.PreviewContext;
import org.alfresco.wcm.util.WCMUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

public class VirtualisationServerPreviewURIService
extends AbstractPreviewURIServiceProvider {
    public static final String DEFAULT_VSERVER_IP = "127-0-0-1.ip.alfrescodemo.net";
    public static final int DEFAULT_VSERVER_PORT = 8180;
    public static final String PREVIEW_SANDBOX_URL = "http://{0}.www--sandbox.{1}:{2}";
    public static final String PREVIEW_ASSET_URL = "http://{0}.www--sandbox.{1}:{2}{3}";
    private AVMService avmService;
    private VirtServerRegistry virtSvrRegistry;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setVirtServerRegistry(VirtServerRegistry virtSvrRegistry) {
        this.virtSvrRegistry = virtSvrRegistry;
    }

    public String getPreviewURI(String sbStoreId, String pathToAsset, PreviewContext ignored) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        if (pathToAsset == null || pathToAsset.length() == 0) {
            return this.buildPreviewStoreUrl(sbStoreId, this.getVServerDomain(), this.getVServerPort(), WCMUtil.lookupStoreDNS(this.avmService, sbStoreId));
        }
        if (!pathToAsset.startsWith("/www/avm_webapps")) {
            throw new IllegalStateException("Invalid asset path in AVM node ref: " + sbStoreId + ":" + pathToAsset);
        }
        return this.buildPreviewAssetUrl(pathToAsset, this.getVServerDomain(), this.getVServerPort(), WCMUtil.lookupStoreDNS(this.avmService, sbStoreId));
    }

    private String buildPreviewStoreUrl(String sbStoreId, String domain, String port, String dns) {
        return MessageFormat.format(PREVIEW_SANDBOX_URL, dns, domain, port);
    }

    private String buildPreviewAssetUrl(String assetPath, String domain, String port, String dns) {
        ParameterCheck.mandatoryString((String)"assetPath", (String)assetPath);
        if (domain == null || port == null || dns == null) {
            throw new IllegalArgumentException("Domain, port and dns name are mandatory.");
        }
        if (assetPath.startsWith("/www/avm_webapps")) {
            assetPath = assetPath.substring("/www/avm_webapps".length());
        }
        if (assetPath.startsWith("/ROOT")) {
            assetPath = assetPath.substring("/ROOT".length());
        }
        assetPath = AVMUtil.addLeadingSlash(assetPath);
        return MessageFormat.format(PREVIEW_ASSET_URL, dns, domain, port, assetPath);
    }

    private String getVServerPort() {
        Integer port;
        Integer n = port = this.virtSvrRegistry != null ? this.virtSvrRegistry.getVirtServerHttpPort() : null;
        if (port == null) {
            port = 8180;
        }
        return port.toString();
    }

    private String getVServerDomain() {
        String domain;
        String string = domain = this.virtSvrRegistry != null ? this.virtSvrRegistry.getVirtServerFQDN() : null;
        if (domain == null) {
            domain = DEFAULT_VSERVER_IP;
        }
        return domain;
    }
}

