/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;

public class FSDirectory
extends Directory {
    private static final Map DIRECTORIES = new HashMap();
    private static boolean disableLocks = false;
    public static final String LOCK_DIR = System.getProperty("org.apache.lucene.lockDir", System.getProperty("java.io.tmpdir"));
    private static Class IMPL;
    private static MessageDigest DIGESTER;
    private byte[] buffer = null;
    private File directory = null;
    private int refCount;
    private static final char[] HEX_DIGITS;

    public static void setDisableLocks(boolean doDisableLocks) {
        disableLocks = doDisableLocks;
    }

    public static boolean getDisableLocks() {
        return disableLocks;
    }

    public static FSDirectory getDirectory(String path) throws IOException {
        return FSDirectory.getDirectory(new File(path), null);
    }

    public static FSDirectory getDirectory(String path, LockFactory lockFactory) throws IOException {
        return FSDirectory.getDirectory(new File(path), lockFactory);
    }

    public static FSDirectory getDirectory(File file) throws IOException {
        return FSDirectory.getDirectory(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, LockFactory lockFactory) throws IOException {
        FSDirectory dir;
        if ((file = new File(file.getCanonicalPath())).exists() && !file.isDirectory()) {
            throw new IOException(file + " not a directory");
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot create directory: " + file);
        }
        Object object = DIRECTORIES;
        synchronized (object) {
            dir = (FSDirectory)((Object)DIRECTORIES.get(file));
            if (dir == null) {
                try {
                    dir = (FSDirectory)((Object)IMPL.newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot load FSDirectory class: " + e.toString(), e);
                }
                dir.init(file, lockFactory);
                DIRECTORIES.put(file, dir);
            } else if (lockFactory != null && lockFactory != dir.getLockFactory()) {
                throw new IOException("Directory was previously created with a different LockFactory instance; please pass null as the lockFactory instance and use setLockFactory to change it");
            }
        }
        object = dir;
        synchronized (object) {
            ++dir.refCount;
        }
        return dir;
    }

    public static FSDirectory getDirectory(String path, boolean create) throws IOException {
        return FSDirectory.getDirectory(new File(path), create);
    }

    public static FSDirectory getDirectory(File file, boolean create) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(file, null);
        if (create) {
            dir.create();
        }
        return dir;
    }

    private void create() throws IOException {
        if (this.directory.exists()) {
            String[] files = this.directory.list((FilenameFilter)IndexFileNameFilter.getFilter());
            if (files == null) {
                throw new IOException("cannot read directory " + this.directory.getAbsolutePath() + ": list() returned null");
            }
            for (int i = 0; i < files.length; ++i) {
                File file = new File(this.directory, files[i]);
                if (file.delete()) continue;
                throw new IOException("Cannot delete " + file);
            }
        }
        this.lockFactory.clearLock("write.lock");
    }

    protected FSDirectory() {
    }

    private void init(File path, LockFactory lockFactory) throws IOException {
        this.directory = path;
        boolean doClearLockID = false;
        if (lockFactory == null) {
            if (disableLocks) {
                lockFactory = NoLockFactory.getNoLockFactory();
            } else {
                String lockClassName = System.getProperty("org.apache.lucene.store.FSDirectoryLockFactoryClass");
                if (lockClassName != null && !lockClassName.equals("")) {
                    Class<?> c;
                    try {
                        c = Class.forName(lockClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("unable to find LockClass " + lockClassName);
                    }
                    try {
                        lockFactory = (LockFactory)c.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new IOException("IllegalAccessException when instantiating LockClass " + lockClassName);
                    }
                    catch (InstantiationException e) {
                        throw new IOException("InstantiationException when instantiating LockClass " + lockClassName);
                    }
                    catch (ClassCastException e) {
                        throw new IOException("unable to cast LockClass " + lockClassName + " instance to a LockFactory");
                    }
                    if (lockFactory instanceof NativeFSLockFactory) {
                        ((NativeFSLockFactory)lockFactory).setLockDir(path);
                    } else if (lockFactory instanceof SimpleFSLockFactory) {
                        ((SimpleFSLockFactory)lockFactory).setLockDir(path);
                    }
                } else {
                    lockFactory = new SimpleFSLockFactory(path);
                    doClearLockID = true;
                }
            }
        }
        this.setLockFactory(lockFactory);
        if (doClearLockID) {
            lockFactory.setLockPrefix(null);
        }
    }

    public String[] list() {
        this.ensureOpen();
        return this.directory.list((FilenameFilter)IndexFileNameFilter.getFilter());
    }

    public boolean fileExists(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.exists();
    }

    public long fileModified(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.lastModified();
    }

    public static long fileModified(File directory, String name) {
        File file = new File(directory, name);
        return file.lastModified();
    }

    public void touchFile(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        file.setLastModified(System.currentTimeMillis());
    }

    public long fileLength(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.length();
    }

    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        File file = new File(this.directory, name);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void renameFile(String from, String to) throws IOException {
        this.ensureOpen();
        File old = new File(this.directory, from);
        File nu = new File(this.directory, to);
        if (nu.exists() && !nu.delete()) {
            throw new IOException("Cannot delete " + nu);
        }
        if (old.renameTo(nu)) return;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                int len;
                in = new FileInputStream(old);
                out = new FileOutputStream(nu);
                if (this.buffer == null) {
                    this.buffer = new byte[1024];
                }
                while ((len = ((InputStream)in).read(this.buffer)) >= 0) {
                    ((OutputStream)out).write(this.buffer, 0, len);
                }
                old.delete();
            }
            catch (IOException ioe) {
                IOException newExc = new IOException("Cannot rename " + old + " to " + nu);
                newExc.initCause(ioe);
                throw newExc;
            }
            Object var10_9 = null;
            try {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot close input stream: " + e.toString(), e);
                    }
                }
                Object var13_13 = null;
                if (out == null) return;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (out == null) throw throwable;
                try {}
                catch (IOException e) {
                    throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
                }
                ((OutputStream)out).close();
                throw throwable;
            }
            try {
                ((OutputStream)out).close();
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {}
            catch (Throwable throwable2) {
                Object var13_16 = null;
                if (out == null) throw throwable2;
                try {}
                catch (IOException e) {
                    throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
                }
                ((OutputStream)out).close();
                throw throwable2;
            }
            if (in != null) {
                try {}
                catch (IOException e) {
                    throw new RuntimeException("Cannot close input stream: " + e.toString(), e);
                }
                ((InputStream)in).close();
            }
            Object var13_15 = null;
            if (out == null) throw throwable;
            try {}
            catch (IOException e) {
                throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
            }
            ((OutputStream)out).close();
            throw throwable;
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        this.ensureOpen();
        File file = new File(this.directory, name);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
        return new FSIndexOutput(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(String name) throws IOException {
        this.ensureOpen();
        File fullFile = new File(this.directory, name);
        boolean success = false;
        int retryCount = 0;
        IOException exc = null;
        while (!success && retryCount < 5) {
            ++retryCount;
            RandomAccessFile file = null;
            try {
                Object var8_9;
                try {
                    file = new RandomAccessFile(fullFile, "rw");
                    file.getFD().sync();
                    success = true;
                    var8_9 = null;
                    if (file == null) continue;
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    if (file != null) {
                        file.close();
                    }
                    throw throwable;
                }
                file.close();
                {
                }
            }
            catch (IOException ioe) {
                if (exc == null) {
                    exc = ioe;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (!success) {
            throw exc;
        }
    }

    public IndexInput openInput(String name) throws IOException {
        this.ensureOpen();
        return this.openInput(name, 1024);
    }

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        this.ensureOpen();
        return new FSIndexInput(new File(this.directory, name), bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockID() {
        byte[] digest;
        String dirName;
        this.ensureOpen();
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        MessageDigest messageDigest = DIGESTER;
        synchronized (messageDigest) {
            digest = DIGESTER.digest(dirName.getBytes());
        }
        StringBuffer buf = new StringBuffer();
        buf.append("lucene-");
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.isOpen && --this.refCount <= 0) {
            this.isOpen = false;
            Map map = DIRECTORIES;
            synchronized (map) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public File getFile() {
        this.ensureOpen();
        return this.directory;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + this.directory;
    }

    static {
        try {
            String name = System.getProperty("org.apache.lucene.FSDirectory.class", FSDirectory.class.getName());
            IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load FSDirectory class: " + e.toString(), e);
        }
        catch (SecurityException se) {
            try {
                IMPL = Class.forName(FSDirectory.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load default FSDirectory class: " + e.toString(), e);
            }
        }
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.toString(), e);
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    protected static class FSIndexOutput
    extends BufferedIndexOutput {
        RandomAccessFile file = null;
        private volatile boolean isOpen;

        public FSIndexOutput(File path) throws IOException {
            this.file = new RandomAccessFile(path, "rw");
            this.file.getChannel();
            this.isOpen = true;
        }

        public void flushBuffer(byte[] b, int offset, int size) throws IOException {
            this.file.write(b, offset, size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            block6: {
                if (!this.isOpen) return;
                boolean success = false;
                try {
                    super.close();
                    success = true;
                    Object var3_2 = null;
                    this.isOpen = false;
                    if (success) break block6;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.isOpen = false;
                    if (success) {
                        this.file.close();
                        throw throwable;
                    }
                    try {
                        this.file.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw throwable;
                    }
                }
                try {}
                catch (Throwable t) {
                    return;
                }
                this.file.close();
                return;
            }
            this.file.close();
        }

        public void seek(long pos) throws IOException {
            super.seek(pos);
            this.file.seek(pos);
        }

        public long length() throws IOException {
            return this.file.length();
        }

        public void setLength(long length) throws IOException {
            this.file.setLength(length);
        }
    }

    protected static class FSIndexInput
    extends BufferedIndexInput {
        protected final Descriptor file;
        boolean isClone;

        public FSIndexInput(File path) throws IOException {
            this(path, 1024);
        }

        public FSIndexInput(File path, int bufferSize) throws IOException {
            super(bufferSize);
            this.file = new Descriptor(path, "r");
        }

        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            int i;
            int total = 0;
            do {
                RandomAccessFile raf = this.file.getFile();
                raf.seek(this.getFilePointer());
                i = raf.read(b, offset + total, len - total);
                if (i != -1) continue;
                throw new IOException("read past EOF");
            } while ((total += i) < len);
        }

        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        protected void seekInternal(long position) {
        }

        public long length() {
            return this.file.length;
        }

        public Object clone() {
            FSIndexInput clone = (FSIndexInput)((Object)super.clone());
            clone.isClone = true;
            return clone;
        }

        boolean isFDValid() throws IOException {
            return this.file.getFile().getFD().valid();
        }

        protected static class Descriptor
        implements Cloneable {
            private boolean isOpen;
            final long length;
            final Map<String, RandomAccessFile> fileMap = new TreeMap<String, RandomAccessFile>();
            final File file;
            final String mode;
            final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

            public Descriptor(File file, String mode) throws IOException {
                this.file = file;
                this.mode = mode;
                this.isOpen = true;
                RandomAccessFile raf = new RandomAccessFile(file, mode);
                this.length = raf.length();
                this.fileMap.put(Thread.currentThread().getName(), raf);
            }

            private RandomAccessFile getFile() {
                RandomAccessFile file;
                block6: {
                    String threadKey = Thread.currentThread().getName();
                    this.lock.readLock().lock();
                    file = this.fileMap.get(threadKey);
                    if (file == null) {
                        this.lock.readLock().unlock();
                        this.lock.writeLock().lock();
                        try {
                            block5: {
                                try {
                                    file = this.fileMap.get(threadKey);
                                    if (file != null) break block5;
                                    file = new RandomAccessFile(this.file, this.mode);
                                    this.fileMap.put(threadKey, file);
                                }
                                catch (FileNotFoundException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            Object var5_3 = null;
                            this.lock.writeLock().unlock();
                            break block6;
                        }
                        catch (Throwable throwable) {
                            Object var5_4 = null;
                            this.lock.writeLock().unlock();
                            throw throwable;
                        }
                    }
                    this.lock.readLock().unlock();
                }
                return file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                this.lock.readLock().lock();
                if (this.isOpen) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    try {
                        if (this.isOpen) {
                            for (RandomAccessFile file : this.fileMap.values()) {
                                file.close();
                            }
                            this.fileMap.clear();
                            this.isOpen = false;
                        }
                        Object var4_3 = null;
                        this.lock.writeLock().unlock();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this.lock.writeLock().unlock();
                        throw throwable;
                    }
                } else {
                    this.lock.readLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    this.close();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    super.finalize();
                    throw throwable;
                }
                super.finalize();
            }
        }
    }
}

