/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webeditor.taglib;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webeditor.taglib.AbstractTemplateTag;

public class StartTemplateTag
extends AbstractTemplateTag {
    private static final long serialVersionUID = -7242916874303242800L;
    protected static final Log logger = LogFactory.getLog(StartTemplateTag.class);
    private String toolbarLocation = "top";

    public String getToolbarLocation() {
        return this.toolbarLocation;
    }

    public void setToolbarLocation(String location) {
        if (location.equalsIgnoreCase("top")) {
            this.toolbarLocation = "top";
        } else if (location.equalsIgnoreCase("left")) {
            this.toolbarLocation = "left";
        } else if (location.equalsIgnoreCase("right")) {
            this.toolbarLocation = "right";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspException {
        if (this.isEditingEnabled()) {
            this.pageContext.getRequest().setAttribute("wef_toolbar_location", (Object)this.getToolbarLocation());
            try {
                JspWriter out = this.pageContext.getOut();
                out.write("<script type=\"text/javascript\" src=\"");
                out.write(this.getWebEditorUrlPrefix());
                out.write("/service/wef/bootstrap");
                if (this.isDebugEnabled()) {
                    out.write("?debug=true");
                }
                this.includeCustomConfiguration((Writer)out);
                out.write("\"></script>\n");
                if (!logger.isDebugEnabled()) return 0;
                logger.debug((Object)"Completed startTemplate rendering");
                return 0;
            }
            catch (IOException ioe) {
                throw new JspException(ioe.toString());
            }
        } else {
            if (!logger.isDebugEnabled()) return 0;
            logger.debug((Object)"Skipping startTemplate rendering as editing is disabled");
        }
        return 0;
    }

    public void includeCustomConfiguration(Writer out) throws IOException {
    }

    public void release() {
        super.release();
        this.toolbarLocation = null;
    }
}

