/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.MultiFilingServicePort;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;

public class MultiFilingServiceImpl
extends AbstractWebServicesService
implements MultiFilingService {
    private final AbstractPortProvider portProvider;

    public MultiFilingServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        MultiFilingServicePort port = this.portProvider.getMultiFilingServicePort();
        try {
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.addObjectToFolder(repositoryId, objectId, folderId, allVersions, portExtension);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        MultiFilingServicePort port = this.portProvider.getMultiFilingServicePort();
        try {
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.removeObjectFromFolder(repositoryId, objectId, folderId, portExtension);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

