/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedirectView
extends AbstractUrlBasedView {
    private boolean contextRelative = false;
    private boolean http10Compatible = true;
    private boolean exposeModelAttributes = true;
    private String encodingScheme;
    private HttpStatus statusCode;

    public RedirectView() {
    }

    public RedirectView(String url) {
        super(url);
    }

    public RedirectView(String url, boolean contextRelative) {
        super(url);
        this.contextRelative = contextRelative;
    }

    public RedirectView(String url, boolean contextRelative, boolean http10Compatible) {
        super(url);
        this.contextRelative = contextRelative;
        this.http10Compatible = http10Compatible;
    }

    public RedirectView(String url, boolean contextRelative, boolean http10Compatible, boolean exposeModelAttributes) {
        super(url);
        this.contextRelative = contextRelative;
        this.http10Compatible = http10Compatible;
        this.exposeModelAttributes = exposeModelAttributes;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public void setHttp10Compatible(boolean http10Compatible) {
        this.http10Compatible = http10Compatible;
    }

    public void setExposeModelAttributes(boolean exposeModelAttributes) {
        this.exposeModelAttributes = exposeModelAttributes;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public void setStatusCode(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder targetUrl = new StringBuilder();
        if (this.contextRelative && this.getUrl().startsWith("/")) {
            targetUrl.append(request.getContextPath());
        }
        targetUrl.append(this.getUrl());
        if (this.exposeModelAttributes) {
            String enc = this.encodingScheme;
            if (enc == null) {
                enc = request.getCharacterEncoding();
            }
            if (enc == null) {
                enc = "ISO-8859-1";
            }
            this.appendQueryProperties(targetUrl, model, enc);
        }
        this.sendRedirect(request, response, targetUrl.toString(), this.http10Compatible);
    }

    protected void appendQueryProperties(StringBuilder targetUrl, Map<String, Object> model, String encodingScheme) throws UnsupportedEncodingException {
        String fragment = null;
        int anchorIndex = targetUrl.indexOf("#");
        if (anchorIndex > -1) {
            fragment = targetUrl.substring(anchorIndex);
            targetUrl.delete(anchorIndex, targetUrl.length());
        }
        boolean first = this.getUrl().indexOf(63) < 0;
        for (Map.Entry<String, Object> entry : this.queryProperties(model).entrySet()) {
            Object rawValue = entry.getValue();
            Iterator<Object> valueIter = rawValue != null && rawValue.getClass().isArray() ? Arrays.asList(ObjectUtils.toObjectArray((Object)rawValue)).iterator() : (rawValue instanceof Collection ? ((Collection)rawValue).iterator() : Collections.singleton(rawValue).iterator());
            while (valueIter.hasNext()) {
                Object value = valueIter.next();
                if (first) {
                    targetUrl.append('?');
                    first = false;
                } else {
                    targetUrl.append('&');
                }
                String encodedKey = this.urlEncode(entry.getKey(), encodingScheme);
                String encodedValue = value != null ? this.urlEncode(value.toString(), encodingScheme) : "";
                targetUrl.append(encodedKey).append('=').append(encodedValue);
            }
        }
        if (fragment != null) {
            targetUrl.append(fragment);
        }
    }

    protected Map<String, Object> queryProperties(Map<String, Object> model) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            if (!this.isEligibleProperty(entry.getKey(), entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected boolean isEligibleProperty(String key, Object value) {
        if (value == null) {
            return false;
        }
        if (this.isEligibleValue(value)) {
            return true;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return false;
            }
            int i = 0;
            while (i < length) {
                Object element = Array.get(value, i);
                if (!this.isEligibleValue(element)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            if (coll.isEmpty()) {
                return false;
            }
            for (Object element : coll) {
                if (this.isEligibleValue(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isEligibleValue(Object value) {
        return value != null && BeanUtils.isSimpleValueType(value.getClass());
    }

    protected String urlEncode(String input, String encodingScheme) throws UnsupportedEncodingException {
        return input != null ? URLEncoder.encode(input, encodingScheme) : null;
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String targetUrl, boolean http10Compatible) throws IOException {
        if (http10Compatible) {
            response.sendRedirect(response.encodeRedirectURL(targetUrl));
        } else {
            HttpStatus statusCode = this.getHttp11StatusCode(request, response, targetUrl);
            response.setStatus(statusCode.value());
            response.setHeader("Location", response.encodeRedirectURL(targetUrl));
        }
    }

    protected HttpStatus getHttp11StatusCode(HttpServletRequest request, HttpServletResponse response, String targetUrl) {
        if (this.statusCode != null) {
            return this.statusCode;
        }
        HttpStatus attributeStatusCode = (HttpStatus)request.getAttribute(View.RESPONSE_STATUS_ATTRIBUTE);
        if (attributeStatusCode != null) {
            return attributeStatusCode;
        }
        return HttpStatus.SEE_OTHER;
    }
}

