/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache.decorators;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;

public class WeakCache
implements Cache {
    private final LinkedList hardLinksToAvoidGarbageCollection;
    private final ReferenceQueue queueOfGarbageCollectedEntries;
    private final Cache delegate;
    private int numberOfHardLinks;

    public WeakCache(Cache delegate) {
        this.delegate = delegate;
        this.numberOfHardLinks = 256;
        this.hardLinksToAvoidGarbageCollection = new LinkedList();
        this.queueOfGarbageCollectedEntries = new ReferenceQueue();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public int getSize() {
        this.removeGarbageCollectedItems();
        return this.delegate.getSize();
    }

    public void setSize(int size) {
        this.numberOfHardLinks = size;
    }

    public void putObject(Object key, Object value) {
        this.removeGarbageCollectedItems();
        this.delegate.putObject(key, new WeakEntry(key, value, this.queueOfGarbageCollectedEntries));
    }

    public Object getObject(Object key) {
        Object result = null;
        WeakReference weakReference = (WeakReference)this.delegate.getObject(key);
        if (weakReference != null) {
            result = weakReference.get();
            if (result == null) {
                this.delegate.removeObject(key);
            } else {
                this.hardLinksToAvoidGarbageCollection.addFirst(result);
                if (this.hardLinksToAvoidGarbageCollection.size() > this.numberOfHardLinks) {
                    this.hardLinksToAvoidGarbageCollection.removeLast();
                }
            }
        }
        return result;
    }

    public Object removeObject(Object key) {
        this.removeGarbageCollectedItems();
        return this.delegate.removeObject(key);
    }

    public void clear() {
        this.hardLinksToAvoidGarbageCollection.clear();
        this.removeGarbageCollectedItems();
        this.delegate.clear();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    private void removeGarbageCollectedItems() {
        WeakEntry sv;
        while ((sv = (WeakEntry)this.queueOfGarbageCollectedEntries.poll()) != null) {
            this.delegate.removeObject(sv.key);
        }
    }

    private static class WeakEntry
    extends WeakReference {
        private final Object key;

        private WeakEntry(Object key, Object value, ReferenceQueue garbageCollectionQueue) {
            super(value, garbageCollectionQueue);
            this.key = key;
        }
    }
}

