/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor;

import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.TransactionalCacheManager;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;

public class CachingExecutor
implements Executor {
    private Executor delegate;
    private TransactionalCacheManager tcm = new TransactionalCacheManager();

    public CachingExecutor(Executor delegate) {
        this.delegate = delegate;
    }

    @Override
    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    @Override
    public void close(boolean forceRollback) {
        try {
            this.tcm.commit();
        }
        finally {
            this.delegate.close(forceRollback);
        }
    }

    @Override
    public void setUseLocalCache(boolean useLocalCache) {
        this.delegate.setUseLocalCache(useLocalCache);
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public int update(MappedStatement ms, Object parameterObject) throws SQLException {
        this.flushCacheIfRequired(ms);
        return this.delegate.update(ms, parameterObject);
    }

    @Override
    public List query(MappedStatement ms, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        Cache cache;
        if (ms != null && (cache = ms.getCache()) != null) {
            this.flushCacheIfRequired(ms);
            cache.getReadWriteLock().readLock().lock();
            try {
                if (ms.isUseCache()) {
                    CacheKey key = this.createCacheKey(ms, parameterObject, rowBounds);
                    List cachedList = (List)cache.getObject(key);
                    if (cachedList != null) {
                        List list = cachedList;
                        return list;
                    }
                    List list = this.delegate.query(ms, parameterObject, rowBounds, resultHandler);
                    this.tcm.putObject(cache, key, list);
                    List list2 = list;
                    return list2;
                }
                List list = this.delegate.query(ms, parameterObject, rowBounds, resultHandler);
                return list;
            }
            finally {
                cache.getReadWriteLock().readLock().unlock();
            }
        }
        return this.delegate.query(ms, parameterObject, rowBounds, resultHandler);
    }

    public List flushStatements() throws SQLException {
        return this.delegate.flushStatements();
    }

    @Override
    public void commit(boolean required) throws SQLException {
        this.delegate.commit(required);
        this.tcm.commit();
    }

    @Override
    public void rollback(boolean required) throws SQLException {
        try {
            this.delegate.rollback(required);
        }
        finally {
            if (required) {
                this.tcm.rollback();
            }
        }
    }

    @Override
    public CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return this.delegate.createCacheKey(ms, parameterObject, rowBounds);
    }

    @Override
    public boolean isCached(MappedStatement ms, CacheKey key) {
        throw new UnsupportedOperationException("The CachingExecutor should not be used by result loaders and thus isCached() should never be called.");
    }

    @Override
    public void deferLoad(MappedStatement ms, MetaObject resultObject, String property, CacheKey key) {
        throw new UnsupportedOperationException("The CachingExecutor should not be used by result loaders and thus deferLoad() should never be called.");
    }

    @Override
    public void clearLocalCache() {
        this.delegate.clearLocalCache();
    }

    private void flushCacheIfRequired(MappedStatement ms) {
        Cache cache = ms.getCache();
        if (cache != null && ms.isFlushCacheRequired()) {
            this.tcm.clear(cache);
        }
    }
}

