/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.jdbc.SqlRunner;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationReader;
import org.apache.ibatis.migration.commands.BaseCommand;

public class DownCommand
extends BaseCommand {
    public DownCommand(File repository, String environment, boolean force) {
        super(repository, environment, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String ... params) {
        try {
            Change lastChange = this.getLastAppliedChange();
            List<Change> migrations = this.getMigrations();
            Collections.reverse(migrations);
            int steps = 0;
            for (Change change : migrations) {
                if (!change.getId().equals(lastChange.getId())) continue;
                this.printStream.println(this.horizontalLine("Undoing: " + change.getFilename(), 80));
                ScriptRunner runner = this.getScriptRunner();
                try {
                    runner.runScript(new MigrationReader(new FileReader(this.scriptFile(change.getFilename())), true, this.environmentProperties()));
                }
                finally {
                    runner.closeConnection();
                }
                if (this.changelogExists()) {
                    this.deleteChange(change);
                } else {
                    this.printStream.println("Changelog doesn't exist. No further migrations will be undone (normal for the last migration).");
                }
                this.printStream.println();
                int limit = this.getStepCountParameter(1, params);
                if (++steps != limit) {
                    lastChange = this.getLastAppliedChange();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new MigrationException("Error undoing last migration.  Cause: " + e, e);
        }
    }

    protected void deleteChange(Change change) {
        SqlRunner runner = this.getSqlRunner();
        try {
            runner.delete("delete from " + this.changelogTable() + " where id = ?", change.getId());
        }
        catch (SQLException e) {
            throw new MigrationException("Error querying last applied migration.  Cause: " + e, e);
        }
        finally {
            runner.closeConnection();
        }
    }
}

