/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection;

import java.util.Map;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.BeanWrapper;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.MapWrapper;
import org.apache.ibatis.reflection.wrapper.ObjectWrapper;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

public class MetaObject {
    public static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    public static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    public static final MetaObject NULL_META_OBJECT = new MetaObject(NullObject.class, DEFAULT_OBJECT_FACTORY, DEFAULT_OBJECT_WRAPPER_FACTORY);
    private Object originalObject;
    private ObjectWrapper objectWrapper;
    private ObjectFactory objectFactory;
    private ObjectWrapperFactory objectWrapperFactory;

    private MetaObject(Object object, ObjectFactory objectFactory, ObjectWrapperFactory objectWrapperFactory) {
        this.originalObject = object;
        this.objectFactory = objectFactory;
        this.objectWrapperFactory = objectWrapperFactory;
        this.objectWrapper = object instanceof ObjectWrapper ? (ObjectWrapper)object : (objectWrapperFactory.hasWrapperFor(object) ? objectWrapperFactory.getWrapperFor(this, object) : (object instanceof Map ? new MapWrapper(this, (Map)object) : new BeanWrapper(this, object)));
    }

    public static MetaObject forObject(Object object, ObjectFactory objectFactory, ObjectWrapperFactory objectWrapperFactory) {
        if (object == null) {
            return NULL_META_OBJECT;
        }
        return new MetaObject(object, objectFactory, objectWrapperFactory);
    }

    public static MetaObject forObject(Object object) {
        return MetaObject.forObject(object, DEFAULT_OBJECT_FACTORY, DEFAULT_OBJECT_WRAPPER_FACTORY);
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public ObjectWrapperFactory getObjectWrapperFactory() {
        return this.objectWrapperFactory;
    }

    public Object getOriginalObject() {
        return this.originalObject;
    }

    public String findProperty(String propName) {
        return this.objectWrapper.findProperty(propName);
    }

    public String[] getGetterNames() {
        return this.objectWrapper.getGetterNames();
    }

    public String[] getSetterNames() {
        return this.objectWrapper.getSetterNames();
    }

    public Class getSetterType(String name) {
        return this.objectWrapper.getSetterType(name);
    }

    public Class getGetterType(String name) {
        return this.objectWrapper.getGetterType(name);
    }

    public boolean hasSetter(String name) {
        return this.objectWrapper.hasSetter(name);
    }

    public boolean hasGetter(String name) {
        return this.objectWrapper.hasGetter(name);
    }

    public Object getValue(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            MetaObject metaValue = this.metaObjectForProperty(prop.getIndexedName());
            if (metaValue == NULL_META_OBJECT) {
                return null;
            }
            return metaValue.getValue(prop.getChildren());
        }
        return this.objectWrapper.get(prop);
    }

    public void setValue(String name, Object value) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            MetaObject metaValue = this.metaObjectForProperty(prop.getIndexedName());
            if (metaValue == NULL_META_OBJECT) {
                if (value == null && prop.getChildren() != null) {
                    return;
                }
                metaValue = this.objectWrapper.instantiatePropertyValue(name, prop, this.objectFactory);
            }
            metaValue.setValue(prop.getChildren(), value);
        } else {
            this.objectWrapper.set(prop, value);
        }
    }

    public MetaObject metaObjectForProperty(String name) {
        Object value = this.getValue(name);
        return MetaObject.forObject(value, this.objectFactory, this.objectWrapperFactory);
    }

    public ObjectWrapper getObjectWrapper() {
        return this.objectWrapper;
    }

    private static class NullObject {
        private NullObject() {
        }
    }
}

