/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SealedObject;
import org.alfresco.encryption.Encryptor;
import org.alfresco.encryption.KeyProvider;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEncryptor
implements Encryptor {
    protected static final Log logger = LogFactory.getLog(Encryptor.class);
    protected String cipherAlgorithm;
    protected String cipherProvider;
    protected KeyProvider keyProvider;

    protected AbstractEncryptor() {
    }

    public void setKeyProvider(KeyProvider keyProvider) {
        this.keyProvider = keyProvider;
    }

    public KeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    public void init() {
        PropertyCheck.mandatory(this, "keyProvider", this.keyProvider);
    }

    protected abstract Cipher getCipher(String var1, AlgorithmParameters var2, int var3);

    @Override
    public Pair<byte[], AlgorithmParameters> encrypt(String keyAlias, AlgorithmParameters params, byte[] input) {
        Cipher cipher = this.getCipher(keyAlias, params, 1);
        if (cipher == null) {
            return new Pair<byte[], Object>(input, null);
        }
        try {
            byte[] output = cipher.doFinal(input);
            params = cipher.getParameters();
            return new Pair<byte[], AlgorithmParameters>(output, params);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Decryption failed for key alias: " + keyAlias, e);
        }
    }

    protected void resetCipher() {
    }

    @Override
    public byte[] decrypt(String keyAlias, AlgorithmParameters params, byte[] input) {
        Cipher cipher = this.getCipher(keyAlias, params, 2);
        if (cipher == null) {
            return input;
        }
        try {
            return cipher.doFinal(input);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Decryption failed for key alias: " + keyAlias, e);
        }
    }

    @Override
    public InputStream decrypt(String keyAlias, AlgorithmParameters params, InputStream input) {
        Cipher cipher = this.getCipher(keyAlias, params, 2);
        if (cipher == null) {
            return input;
        }
        try {
            return new CipherInputStream(input, cipher);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Decryption failed for key alias: " + keyAlias, e);
        }
    }

    @Override
    public Pair<byte[], AlgorithmParameters> encryptObject(String keyAlias, AlgorithmParameters params, Object input) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(input);
            byte[] unencrypted = bos.toByteArray();
            return this.encrypt(keyAlias, params, unencrypted);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to serialize or encrypt object", e);
        }
    }

    @Override
    public Object decryptObject(String keyAlias, AlgorithmParameters params, byte[] input) {
        try {
            byte[] unencrypted = this.decrypt(keyAlias, params, input);
            ByteArrayInputStream bis = new ByteArrayInputStream(unencrypted);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object obj = ois.readObject();
            return obj;
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to deserialize or decrypt object", e);
        }
    }

    @Override
    public Serializable sealObject(String keyAlias, AlgorithmParameters params, Serializable input) {
        if (input == null) {
            return null;
        }
        Cipher cipher = this.getCipher(keyAlias, params, 1);
        if (cipher == null) {
            return input;
        }
        try {
            return new SealedObject(input, cipher);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to seal object", e);
        }
    }

    @Override
    public Serializable unsealObject(String keyAlias, Serializable input) throws InvalidKeyException {
        if (input == null) {
            return input;
        }
        if (!(input instanceof SealedObject)) {
            return input;
        }
        Key key = this.keyProvider.getKey(keyAlias);
        if (key == null) {
            throw new IllegalStateException("No key matching " + keyAlias + ".  Cannot unseal object.");
        }
        SealedObject sealedInput = (SealedObject)input;
        try {
            Serializable output = (Serializable)sealedInput.getObject(key);
            return output;
        }
        catch (InvalidKeyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to unseal object", e);
        }
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherProvider(String cipherProvider) {
        this.cipherProvider = cipherProvider;
    }

    public String getCipherProvider() {
        return this.cipherProvider;
    }

    @Override
    public AlgorithmParameters decodeAlgorithmParameters(byte[] encoded) {
        try {
            AlgorithmParameters p = null;
            String algorithm = "DESede";
            p = this.getCipherProvider() != null ? AlgorithmParameters.getInstance(algorithm, this.getCipherProvider()) : AlgorithmParameters.getInstance(algorithm);
            p.init(encoded);
            return p;
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("", e);
        }
    }
}

