/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.scripts;

import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.scripts.ScriptException;
import org.alfresco.scripts.ScriptResourceLoader;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptResourceHelper {
    private static final String SCRIPT_ROOT = "_root";
    private static final String IMPORT_PREFIX = "<import";
    private static final String IMPORT_RESOURCE = "resource=\"";

    public static String resolveScriptImports(String script, ScriptResourceLoader loader, Log logger) {
        LinkedHashMap<String, String> scriptlets = new LinkedHashMap<String, String>(8, 1.0f);
        ScriptResourceHelper.recurseScriptImports(SCRIPT_ROOT, script, loader, scriptlets, logger);
        if (scriptlets.size() == 1) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Script content resolved to:\r\n" + script));
            }
            return script;
        }
        int length = 0;
        for (String scriptlet : scriptlets.values()) {
            length += scriptlet.length();
        }
        StringBuilder result = new StringBuilder(length);
        for (String scriptlet : scriptlets.values()) {
            result.append(scriptlet);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Script content resolved to:\r\n" + result.toString()));
        }
        return result.toString();
    }

    private static void recurseScriptImports(String location, String script, ScriptResourceLoader loader, Map<String, String> scripts, Log logger) {
        int index;
        for (index = 0; index < script.length() && Character.isWhitespace(script.charAt(index)); ++index) {
        }
        if (script.startsWith(IMPORT_PREFIX, index)) {
            boolean afterWhitespace = false;
            index += IMPORT_PREFIX.length() + 1;
            while (index < script.length()) {
                if (!Character.isWhitespace(script.charAt(index))) {
                    afterWhitespace = true;
                    break;
                }
                ++index;
            }
            if (afterWhitespace && script.startsWith(IMPORT_RESOURCE, index)) {
                int resourceStart = index += IMPORT_RESOURCE.length();
                while (index < script.length()) {
                    if (script.charAt(index) == '\"' && script.charAt(index + 1) == '>') {
                        String resource = script.substring(resourceStart, index);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found script resource import: " + resource));
                        }
                        if (!scripts.containsKey(resource)) {
                            String includedScript = loader.loadScriptResource(resource);
                            if (includedScript != null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Succesfully located script '" + resource + "'"));
                                }
                                ScriptResourceHelper.recurseScriptImports(resource, includedScript, loader, scripts, logger);
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Note: already imported resource: " + resource));
                        }
                        index += 2;
                        while (index < script.length() && Character.isWhitespace(script.charAt(index))) {
                            ++index;
                        }
                        ScriptResourceHelper.recurseScriptImports(location, script.substring(index), loader, scripts, logger);
                        return;
                    }
                    ++index;
                }
                throw new ScriptException("Malformed 'import' line - must be first in file, no comments and strictly of the form:\r\n<import resource=\"...\">");
            }
            throw new ScriptException("Malformed 'import' line - must be first in file, no comments and strictly of the form:\r\n<import resource=\"...\">");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Imports resolved, adding resource '" + location));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)script);
        }
        scripts.put(location, script);
    }
}

