/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.alfresco.util.RegexNameMatcher;

public class RegexNameMatcherTest
extends TestCase {
    public RegexNameMatcherTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRegexNameMatcher() {
        RegexNameMatcher matcher = new RegexNameMatcher();
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add("[A-Za-z0-9:/_]*ROOT/myapp/dir1/*");
        matcher.setPatterns(patterns);
        boolean ret = matcher.matches("ROOT/myapp/dir1");
        RegexNameMatcherTest.assertTrue((boolean)ret);
        boolean ret2 = matcher.matches("xxROOT/myapp/dir1");
        RegexNameMatcherTest.assertTrue((boolean)ret2);
        boolean ret3 = matcher.matches("test20text:/www/avm_webapps/ROOT/myapp/dir1");
        RegexNameMatcherTest.assertTrue((boolean)ret3);
        boolean ret4 = matcher.matches("test20text:/www/avm_webapps/ROOT/myapp/dir11");
        RegexNameMatcherTest.assertTrue((!ret4 ? 1 : 0) != 0);
        boolean ret5 = matcher.matches("test20text:/www/avm_webapps/ROOT/myapp/dir666");
        RegexNameMatcherTest.assertTrue((!ret5 ? 1 : 0) != 0);
        boolean ret6 = matcher.matches("test20text:/www/avm_webapps/ROOT/zzz/dir1");
        RegexNameMatcherTest.assertTrue((!ret6 ? 1 : 0) != 0);
    }

    public void testRegexGif() {
        RegexNameMatcher matcher = new RegexNameMatcher();
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add(".*.jpg");
        matcher.setPatterns(patterns);
        boolean ret = matcher.matches("ROOT/myapp/file.jpg");
        RegexNameMatcherTest.assertTrue((boolean)ret);
        boolean ret2 = matcher.matches("xxROOT/myapp/dir1.gif");
        RegexNameMatcherTest.assertFalse((boolean)ret2);
    }

    public void testRegexGifAndJpg() {
        RegexNameMatcher matcher = new RegexNameMatcher();
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add(".*.jpg$|.*.gif$");
        matcher.setPatterns(patterns);
        boolean ret = matcher.matches("ROOT/myapp/file.jpg");
        RegexNameMatcherTest.assertTrue((boolean)ret);
        boolean ret2 = matcher.matches("xxROOT/myapp/dir1.gif");
        RegexNameMatcherTest.assertTrue((boolean)ret2);
        boolean ret3 = matcher.matches("xxROOT/myapp/dir7.png");
        RegexNameMatcherTest.assertFalse((boolean)ret3);
        boolean ret4 = matcher.matches("xxROOT/myapp/dir7.png.old");
        RegexNameMatcherTest.assertFalse((boolean)ret3);
    }
}

