/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestProgressMonitor;
import org.apache.chemistry.opencmis.tck.impl.WrapperCmisTestGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunner {
    public static final String OVERRIDE_KEY = "org.apache.chemistry";
    public static final String DEFAULT_TCK_GROUPS = "/cmis-tck-groups.txt";
    public static final String TCK_BUILD_TIMESTAMP = "/META-INF/build-timestamp.txt";
    public static final String TCK_BUILD_TIMESTAMP_PARAMETER = "org.apache.chemistry.opencmis.tck.timestamp";
    private Map<String, String> parameters;
    private final List<CmisTestGroup> groups = new ArrayList<CmisTestGroup>();
    private boolean isCanceled = false;

    public void setParameters(Map<String, String> orgParameters) {
        this.parameters = new HashMap<String, String>();
        if (orgParameters != null) {
            this.parameters.putAll(orgParameters);
        }
        for (Object key : System.getProperties().keySet()) {
            if (!key.toString().startsWith(OVERRIDE_KEY)) continue;
            this.parameters.put(key.toString(), System.getProperties().getProperty(key.toString()));
        }
        this.parameters.put(TCK_BUILD_TIMESTAMP_PARAMETER, this.loadTCKTimestamp());
    }

    public void loadParameters(File file) throws Exception {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("File not found!");
        }
        this.loadParameters(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadParameters(InputStream stream) throws Exception {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is null!");
        }
        BufferedReader reader = null;
        HashMap<String, String> loadParams = new HashMap<String, String>();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                int x = line.indexOf(61);
                if (x < 0) {
                    loadParams.put(line.trim(), "");
                    continue;
                }
                loadParams.put(line.substring(0, x).trim(), line.substring(x + 1).trim());
            }
            this.setParameters(loadParams);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private String loadTCKTimestamp() {
        StringBuilder result = new StringBuilder();
        InputStream stream = this.getClass().getResourceAsStream(TCK_BUILD_TIMESTAMP);
        if (stream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                String s = null;
                while ((s = br.readLine()) != null) {
                    result.append(s);
                }
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public void loadDefaultTckGroups() throws Exception {
        this.loadGroups(this.getClass().getResourceAsStream(DEFAULT_TCK_GROUPS));
    }

    public void loadGroups(File file) throws Exception {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("File not found!");
        }
        this.loadGroups(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGroups(InputStream stream) throws Exception {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is null!");
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                this.addGroup(line);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void addGroups(String[] groupClasses) throws Exception {
        if (groupClasses == null) {
            return;
        }
        for (String groupClass : groupClasses) {
            this.addGroup(groupClass);
        }
    }

    public void addGroup(String groupClass) throws Exception {
        if (groupClass == null) {
            return;
        }
        if ((groupClass = groupClass.trim()).length() == 0) {
            return;
        }
        Class<?> clazz = Class.forName(groupClass);
        Object o = clazz.newInstance();
        CmisTestGroup group = null;
        if (o instanceof CmisTestGroup) {
            group = (CmisTestGroup)o;
        } else if (o instanceof CmisTest) {
            group = new WrapperCmisTestGroup((CmisTest)o);
        } else {
            throw new Exception("Not a CmisTestGroup or CmisTest class!");
        }
        this.addGroup(group);
    }

    public void addGroup(CmisTestGroup group) throws Exception {
        if (group != null) {
            group.init(this.parameters);
            this.groups.add(group);
        }
    }

    public List<CmisTestGroup> getGroups() {
        return this.groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CmisTestProgressMonitor monitor) throws Exception {
        this.isCanceled = false;
        for (CmisTestGroup group : this.groups) {
            AbstractRunner abstractRunner = this;
            synchronized (abstractRunner) {
                if (this.isCanceled) {
                    break;
                }
            }
            if (group == null || !group.isEnabled()) continue;
            group.setProgressMonitor(monitor);
            group.run();
        }
    }

    public synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized void cancel() {
        this.isCanceled = true;
    }
}

