/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSmokeTest
extends AbstractSessionTest {
    private static final String NAME1 = "updatetest1.txt";
    private static final String NAME2 = "updatetest2.txt";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Update Smoke Test");
        this.setDescription("Creates a document, updates its name and finally deletes it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        try {
            Document doc1;
            Folder testFolder = this.createTestFolder(session);
            Document workDoc = doc1 = this.createDocument(session, testFolder, NAME1, "rename me!");
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Document name doesn't match with given name!");
            this.addResult(this.assertEquals(NAME1, doc1.getName(), null, (CmisTestResult)f));
            boolean checkedout = false;
            DocumentTypeDefinition type = (DocumentTypeDefinition)doc1.getType();
            PropertyDefinition namePropDef = (PropertyDefinition)type.getPropertyDefinitions().get("cmis:name");
            if (namePropDef.getUpdatability() == Updatability.WHENCHECKEDOUT) {
                workDoc = (Document)session.getObject(doc1.checkOut(), SELECT_ALL_NO_CACHE_OC);
                checkedout = true;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", NAME2);
            ObjectId newId = workDoc.updateProperties(properties, false);
            Document doc2 = (Document)session.getObject(newId, SELECT_ALL_NO_CACHE_OC);
            this.addResult(this.checkObject(session, (CmisObject)doc2, this.getAllProperties((CmisObject)doc2), "Updated document compliance"));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document name doesn't match updated value!");
            this.addResult(this.assertEquals(NAME2, doc2.getName(), null, (CmisTestResult)f));
            if (checkedout) {
                workDoc.cancelCheckOut();
            }
            this.deleteObject((CmisObject)doc2);
            if (!doc1.getId().equals(doc2.getId())) {
                this.deleteObject((CmisObject)doc1);
            }
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

