/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSessionFactoryBean
implements FactoryBean<SqlSessionFactory>,
InitializingBean,
ApplicationListener<ApplicationEvent> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Resource[] mapperLocations;
    private DataSource dataSource;
    private TransactionFactory transactionFactory;
    private Properties configurationProperties;
    private SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new SqlSessionFactoryBuilder();
    private SqlSessionFactory sqlSessionFactory;
    private String environment = SqlSessionFactoryBean.class.getSimpleName();
    private boolean failFast;
    private Interceptor[] plugins;
    private TypeHandler[] typeHandlers;
    private String typeHandlersPackage;
    private Class<?>[] typeAliases;
    private String typeAliasesPackage;

    public void setPlugins(Interceptor[] plugins) {
        this.plugins = plugins;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public void setTypeHandlers(TypeHandler[] typeHandlers) {
        this.typeHandlers = typeHandlers;
    }

    public void setTypeAliases(Class<?>[] typeAliases) {
        this.typeAliases = typeAliases;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setConfigurationProperties(Properties sqlSessionFactoryProperties) {
        this.configurationProperties = sqlSessionFactoryProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public void setSqlSessionFactoryBuilder(SqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.sqlSessionFactoryBuilder = sqlSessionFactoryBuilder;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"Property 'dataSource' is required");
        Assert.notNull((Object)this.sqlSessionFactoryBuilder, (String)"Property 'sqlSessionFactoryBuilder' is required");
        this.sqlSessionFactory = this.buildSqlSessionFactory();
    }

    /*
     * WARNING - void declaration
     */
    protected SqlSessionFactory buildSqlSessionFactory() throws IOException {
        String packageToScan;
        int len$;
        String[] arr$;
        Configuration configuration;
        XMLConfigBuilder xmlConfigBuilder = null;
        if (this.configLocation != null) {
            xmlConfigBuilder = new XMLConfigBuilder(this.configLocation.getInputStream(), null, this.configurationProperties);
            configuration = xmlConfigBuilder.getConfiguration();
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Property 'configLocation' not specified, using default MyBatis Configuration");
            }
            configuration = new Configuration();
        }
        if (StringUtils.hasLength((String)this.typeAliasesPackage)) {
            void var6_12;
            String[] typeAliasPackageArray;
            arr$ = typeAliasPackageArray = StringUtils.tokenizeToStringArray((String)this.typeAliasesPackage, (String)",; \t\n");
            len$ = arr$.length;
            boolean bl = false;
            while (var6_12 < len$) {
                packageToScan = arr$[var6_12];
                configuration.getTypeAliasRegistry().registerAliases(packageToScan);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Scanned package: '" + packageToScan + "' for aliases");
                }
                ++var6_12;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeAliases)) {
            for (Class<?> clazz : this.typeAliases) {
                configuration.getTypeAliasRegistry().registerAlias(clazz);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Registered type alias: '" + clazz + "'");
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.plugins)) {
            for (Class<?> clazz : this.plugins) {
                configuration.addInterceptor(clazz);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Registered plugin: '" + clazz + "'");
            }
        }
        if (StringUtils.hasLength((String)this.typeHandlersPackage)) {
            void var6_16;
            String[] typeHandlersPackageArray;
            arr$ = typeHandlersPackageArray = StringUtils.tokenizeToStringArray((String)this.typeHandlersPackage, (String)",; \t\n");
            len$ = arr$.length;
            boolean bl = false;
            while (var6_16 < len$) {
                packageToScan = arr$[var6_16];
                configuration.getTypeHandlerRegistry().register(packageToScan);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Scanned package: '" + packageToScan + "' for type handlers");
                }
                ++var6_16;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeHandlers)) {
            for (Class<?> clazz : this.typeHandlers) {
                configuration.getTypeHandlerRegistry().register(clazz);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Registered type handler: '" + clazz + "'");
            }
        }
        if (xmlConfigBuilder != null) {
            try {
                xmlConfigBuilder.parse();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Parsed configuration file: '" + this.configLocation + "'");
                }
            }
            catch (Exception ex) {
                throw new NestedIOException("Failed to parse config resource: " + this.configLocation, (Throwable)ex);
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
        if (this.transactionFactory == null) {
            this.transactionFactory = new SpringManagedTransactionFactory(this.dataSource);
        }
        Environment environment = new Environment(this.environment, this.transactionFactory, this.dataSource);
        configuration.setEnvironment(environment);
        if (!ObjectUtils.isEmpty((Object[])this.mapperLocations)) {
            void var6_19;
            Resource[] arr$2 = this.mapperLocations;
            len$ = arr$2.length;
            boolean bl = false;
            while (var6_19 < len$) {
                Resource mapperLocation = arr$2[var6_19];
                if (mapperLocation != null) {
                    String path = mapperLocation instanceof ClassPathResource ? ((ClassPathResource)mapperLocation).getPath() : mapperLocation.toString();
                    try {
                        XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(mapperLocation.getInputStream(), configuration, path, configuration.getSqlFragments());
                        xmlMapperBuilder.parse();
                    }
                    catch (Exception e) {
                        throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                    }
                    finally {
                        ErrorContext.instance().reset();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Parsed mapper file: '" + mapperLocation + "'");
                    }
                }
                ++var6_19;
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Property 'mapperLocations' was not specified or no matching resources found");
        }
        return this.sqlSessionFactoryBuilder.build(configuration);
    }

    public SqlSessionFactory getObject() throws Exception {
        if (this.sqlSessionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.sqlSessionFactory;
    }

    public Class<? extends SqlSessionFactory> getObjectType() {
        return this.sqlSessionFactory == null ? SqlSessionFactory.class : this.sqlSessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.failFast && event instanceof ContextRefreshedEvent) {
            this.sqlSessionFactory.getConfiguration().getMappedStatementNames();
        }
    }
}

