/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.junit.Ignore;
import org.springframework.extensions.webscripts.connector.RemoteClient;
import org.springframework.extensions.webscripts.connector.Response;

@Ignore
public class TestRemoteStore
extends TestCase {
    String TEST_CONTENT1 = "some test text";
    String TEST_CONTENT2 = "some text text - updated";

    public void testRemoteStore() {
        RemoteClient remote = new RemoteClient("http://localhost:8080/alfresco/s");
        Response response = remote.call("/api/login?u=admin&pw=admin");
        TestRemoteStore.assertEquals((int)200, (int)response.getStatus().getCode());
        String ticket = null;
        try {
            ticket = DocumentHelper.parseText((String)response.getResponse()).getRootElement().getTextTrim();
        }
        catch (DocumentException de) {
            TestRemoteStore.fail((String)"Failed to extract ticket from login API call.");
        }
        remote.setTicket(ticket);
        String filename0 = Long.toString(new Random().nextLong()) + ".txt";
        Response res = remote.call("/remotestore/create/" + filename0, this.TEST_CONTENT1);
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        String randdir = Long.toString(new Random().nextLong());
        res = remote.call("/remotestore/create/" + randdir + "/" + filename0, this.TEST_CONTENT1);
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        String randdir2 = randdir + "/" + Long.toString(new Random().nextLong());
        res = remote.call("/remotestore/create/" + randdir2 + "/" + filename0, this.TEST_CONTENT1);
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        String filename = Long.toString(new Random().nextLong()) + ".txt";
        res = remote.call("/remotestore/create/" + filename, (InputStream)new ByteArrayInputStream(this.TEST_CONTENT1.getBytes()));
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        res = remote.call("/remotestore/get/" + filename);
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        TestRemoteStore.assertEquals((String)this.TEST_CONTENT1, (String)res.getResponse());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        res = remote.call("/remotestore/get/" + filename, (OutputStream)out);
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        TestRemoteStore.assertEquals((String)this.TEST_CONTENT1, (String)out.toString());
        res = remote.call("/remotestore/has/" + filename);
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        TestRemoteStore.assertEquals((String)res.getResponse(), (String)"true");
        res = remote.call("/remotestore/has/_shouldnotexist.doc");
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        TestRemoteStore.assertEquals((String)res.getResponse(), (String)"false");
        res = remote.call("/remotestore/update/" + filename, (InputStream)new ByteArrayInputStream(this.TEST_CONTENT2.getBytes()));
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        out = new ByteArrayOutputStream();
        res = remote.call("/remotestore/get/" + filename, (OutputStream)out);
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        TestRemoteStore.assertEquals((String)this.TEST_CONTENT2, (String)out.toString());
        res = remote.call("/remotestore/get/_shouldnotexist.doc");
        TestRemoteStore.assertEquals((int)404, (int)res.getStatus().getCode());
        res = remote.call("/remotestore/listall");
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        StringTokenizer t = new StringTokenizer(res.getResponse(), "\n");
        TestRemoteStore.assertTrue((t.countTokens() != 0 ? 1 : 0) != 0);
        res = remote.call("/remotestore/list/" + randdir);
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        t = new StringTokenizer(res.getResponse(), "\n");
        TestRemoteStore.assertEquals((int)t.countTokens(), (int)1);
        res = remote.call("/remotestore/listall/" + randdir);
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        t = new StringTokenizer(res.getResponse(), "\n");
        TestRemoteStore.assertEquals((int)t.countTokens(), (int)2);
        res = remote.call("/remotestore/list/shouldnotexist");
        TestRemoteStore.assertEquals((int)404, (int)res.getStatus().getCode());
        res = remote.call("/remotestore/listpattern/" + randdir + "?m=*.nomatch");
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        t = new StringTokenizer(res.getResponse(), "\n");
        TestRemoteStore.assertTrue((t.countTokens() == 0 ? 1 : 0) != 0);
        res = remote.call("/remotestore/listpattern/" + randdir + "?m=*.txt");
        TestRemoteStore.assertEquals((int)200, (int)res.getStatus().getCode());
        t = new StringTokenizer(res.getResponse(), "\n");
        TestRemoteStore.assertTrue((t.countTokens() == 2 ? 1 : 0) != 0);
    }
}

