/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.json;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.json.JSONUtils;
import org.springframework.extensions.webscripts.processor.JSScriptProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtilsTest
extends TestCase {
    private static WrapFactory wrapFactory = new JSScriptProcessor.PresentationWrapFactory();
    private static final String SCRIPT_1 = "var obj = new Object();obj.string = \"string\";obj.number = 1;obj.number2 = 3.142;obj.date = new Date();obj.myObject = new Object();   obj.myObject.hello = \"hello\";   obj.myObject.goodbye = 123;jsonUtils.toJSONString(obj);";
    private static final String SCRIPT_2 = "var array = Array();array[\"a\"] = \"a value\";array[\"b\"] = \"b value\";jsonUtils.toJSONString(array);";
    private static final String SCRIPT_3 = "var array = Array();var myObject = new Object();myObject.hello = \"hello\";myObject.goodbye = 123;array[0] = \"one\";array[1] = 12;array[2] = 3.142;array[3] = true;array[4] = myObject;jsonUtils.toJSONString(array);";
    private static final String SCRIPT_4 = "var obj = new Object();obj.value = json.getString(\"string\");jsonUtils.toJSONString(obj);";
    private static final String SCRIPT_5 = "var obj = jsonUtils.toObject(json);obj;";
    private static final String SCRIPT_6 = "var obj = jsonUtils.toObject(jsonString);obj;";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testToJSONString() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("jsonUtils", new JSONUtils());
        Object result = this.executeScript(SCRIPT_1, model, true);
        String value = Context.toString((Object)result);
        System.out.println(value);
        JSONObject obj = new JSONObject(value);
        JSONUtilsTest.assertNotNull((Object)obj);
        JSONUtilsTest.assertEquals((int)1, (int)obj.getInt("number"));
        JSONUtilsTest.assertEquals((String)"string", (String)obj.getString("string"));
        JSONUtilsTest.assertNotNull((String)"date", (Object)obj.getJSONObject("date"));
        JSONUtilsTest.assertEquals((Object)3.142, (Object)obj.getDouble("number2"));
        JSONUtilsTest.assertEquals((Object)"UTC", (Object)obj.getJSONObject("date").get("zone"));
        JSONUtilsTest.assertEquals((Object)"hello", (Object)obj.getJSONObject("myObject").get("hello"));
        JSONUtilsTest.assertEquals((Object)123, (Object)obj.getJSONObject("myObject").get("goodbye"));
        result = this.executeScript(SCRIPT_2, model, true);
        value = Context.toString((Object)result);
        System.out.println(value);
        obj = new JSONObject(value);
        JSONUtilsTest.assertEquals((String)"a value", (String)obj.getString("a"));
        JSONUtilsTest.assertEquals((String)"b value", (String)obj.getString("b"));
        result = this.executeScript(SCRIPT_3, model, true);
        value = Context.toString((Object)result);
        System.out.println(value);
        JSONArray arr = new JSONArray(value);
        JSONUtilsTest.assertEquals((int)5, (int)arr.length());
        JSONUtilsTest.assertEquals((String)"one", (String)arr.getString(0));
        JSONUtilsTest.assertEquals((int)12, (int)arr.getInt(1));
        JSONUtilsTest.assertEquals((Object)3.142, (Object)arr.getDouble(2));
        JSONUtilsTest.assertEquals((boolean)true, (boolean)arr.getBoolean(3));
        JSONUtilsTest.assertEquals((String)"hello", (String)arr.getJSONObject(4).getString("hello"));
        JSONUtilsTest.assertEquals((int)123, (int)arr.getJSONObject(4).getInt("goodbye"));
        JSONObject testObject = new JSONObject();
        testObject.put("string", (Object)"myString");
        model.put("json", testObject);
        result = this.executeScript(SCRIPT_4, model, true);
        value = Context.toString((Object)result);
        System.out.println(value);
    }

    public void testToObject() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("jsonUtils", new JSONUtils());
        JSONObject testObject = new JSONObject();
        testObject.put("string", (Object)"myString");
        testObject.put("int", 10);
        testObject.put("number", 3.142);
        JSONObject subObj = new JSONObject();
        subObj.put("sunValue", (Object)"tad-ahhhh");
        testObject.put("comp1", (Object)subObj);
        model.put("json", testObject);
        model.put("jsonString", testObject.toString());
        Object result = this.executeScript(SCRIPT_5, model, true);
        JSONUtilsTest.assertNotNull((Object)result);
        NativeObject nativeObj = (NativeObject)result;
        JSONUtilsTest.assertEquals((Object)"myString", (Object)nativeObj.get("string", (Scriptable)nativeObj));
        JSONUtilsTest.assertEquals((int)10, (int)((Number)nativeObj.get("int", (Scriptable)nativeObj)).intValue());
        JSONUtilsTest.assertEquals((Object)3.142, (Object)nativeObj.get("number", (Scriptable)nativeObj));
        NativeObject subObjResult = (NativeObject)nativeObj.get("comp1", (Scriptable)nativeObj);
        JSONUtilsTest.assertEquals((Object)"tad-ahhhh", (Object)subObjResult.get("sunValue", (Scriptable)subObjResult));
        result = this.executeScript(SCRIPT_6, model, true);
        JSONUtilsTest.assertNotNull((Object)result);
        nativeObj = (NativeObject)result;
        JSONUtilsTest.assertEquals((Object)"myString", (Object)nativeObj.get("string", (Scriptable)nativeObj));
        JSONUtilsTest.assertEquals((int)10, (int)((Number)nativeObj.get("int", (Scriptable)nativeObj)).intValue());
        JSONUtilsTest.assertEquals((Object)3.142, (Object)nativeObj.get("number", (Scriptable)nativeObj));
        subObjResult = (NativeObject)nativeObj.get("comp1", (Scriptable)nativeObj);
        JSONUtilsTest.assertEquals((Object)"tad-ahhhh", (Object)subObjResult.get("sunValue", (Scriptable)subObjResult));
    }

    private Object executeScript(String script, Map<String, Object> model, boolean secure) {
        Context cx = Context.enter();
        try {
            Object result;
            ScriptableObject scope;
            cx.setWrapFactory(wrapFactory);
            if (!secure) {
                scope = cx.initStandardObjects();
                scope.delete("Packages");
                scope.delete("getClass");
                scope.delete("java");
            } else {
                scope = new ImporterTopLevel(cx);
            }
            if (model != null) {
                for (String key : model.keySet()) {
                    Object obj = model.get(key);
                    ScriptableObject.putProperty((Scriptable)scope, (String)key, (Object)obj);
                }
            }
            Object object = result = cx.evaluateString((Scriptable)scope, script, "AlfrescoScript", 1, null);
            return object;
        }
        catch (Throwable e) {
            throw new WebScriptException(e.getMessage(), e);
        }
        finally {
            Context.exit();
        }
    }
}

