/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.stores;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.junit.Test;
import org.springframework.extensions.webscripts.AbstractWebScriptServerTest;
import org.springframework.extensions.webscripts.ClassPathStore;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathStoreTest
extends AbstractWebScriptServerTest {
    public static int TOTAL_DOCUMENT_COUNT = 10;
    public static int DESC_XML_DOCUMENT_COUNT = 2;

    @Override
    public void setUp() throws ServletException {
        super.setUp();
        this.getClassPathStore().init();
    }

    @Override
    public ArrayList<String> getConfigLocations() {
        ArrayList<String> list = super.getConfigLocations();
        list.add("classpath:org/springframework/extensions/webscripts/stores/spring-webscripts-stores-context.xml");
        return list;
    }

    public ClassPathStore getClassPathStore() {
        return (ClassPathStore)this.getTestServer().getApplicationContext().getBean("webscripts.store.test");
    }

    @Test
    public void testAllDocumentPathsCount() throws Exception {
        String[] allPaths = this.getClassPathStore().getAllDocumentPaths();
        ClassPathStoreTest.assertEquals((int)TOTAL_DOCUMENT_COUNT, (int)allPaths.length);
    }

    @Test
    public void testDescriptionDocumentPathsCount() throws Exception {
        String[] descPaths = this.getClassPathStore().getDescriptionDocumentPaths();
        ClassPathStoreTest.assertEquals((int)DESC_XML_DOCUMENT_COUNT, (int)descPaths.length);
    }

    @Test
    public void testGetDocument() throws Exception {
        InputStream is = this.getClassPathStore().getDocument("file1.txt");
        byte[] array = FileCopyUtils.copyToByteArray((InputStream)is);
        ClassPathStoreTest.assertEquals((int)5, (int)array.length);
    }

    @Test
    public void testGetDocumentPaths() throws Exception {
        String[] paths = this.getClassPathStore().getDocumentPaths("/", false, "*.txt");
        ClassPathStoreTest.assertEquals((int)2, (int)paths.length);
    }

    @Test
    public void testGetDocumentSubPaths() throws Exception {
        String[] paths = this.getClassPathStore().getDocumentPaths("/", true, "*.txt");
        ClassPathStoreTest.assertEquals((int)6, (int)paths.length);
    }

    @Test
    public void testCreateDocument() throws Exception {
        String[] allPaths1 = this.getClassPathStore().getAllDocumentPaths();
        boolean threw = false;
        try {
            this.getClassPathStore().createDocument("file3.txt", "file3");
        }
        catch (IOException ioe) {
            threw = true;
        }
        ClassPathStoreTest.assertTrue((boolean)threw);
        String[] allPath2 = this.getClassPathStore().getAllDocumentPaths();
        ClassPathStoreTest.assertEquals((int)allPaths1.length, (int)allPath2.length);
    }

    @Test
    public void testRemoveDocument() throws Exception {
        String[] allPaths1 = this.getClassPathStore().getAllDocumentPaths();
        boolean threw = false;
        try {
            this.getClassPathStore().removeDocument("file1.txt");
        }
        catch (IOException ioe) {
            threw = true;
        }
        ClassPathStoreTest.assertTrue((boolean)threw);
        String[] allPath2 = this.getClassPathStore().getAllDocumentPaths();
        ClassPathStoreTest.assertEquals((int)allPaths1.length, (int)allPath2.length);
    }

    @Test
    public void testUpdateDocument() throws Exception {
        boolean threw = false;
        try {
            this.getClassPathStore().updateDocument("file1.txt", "an update");
        }
        catch (IOException ioe) {
            threw = true;
        }
        ClassPathStoreTest.assertTrue((boolean)threw);
    }

    @Test
    public void testHasDocument() throws Exception {
        boolean b1 = this.getClassPathStore().hasDocument("file7.txt");
        ClassPathStoreTest.assertEquals((boolean)false, (boolean)b1);
        boolean b2 = this.getClassPathStore().hasDocument("file1.txt");
        ClassPathStoreTest.assertEquals((boolean)true, (boolean)b2);
    }

    @Test
    public void testTemplateLoader() throws Exception {
        TemplateLoader loader = this.getClassPathStore().getTemplateLoader();
        Object templateSource = loader.findTemplateSource("folder2/template.ftl");
        ClassPathStoreTest.assertNotNull((Object)templateSource);
        Reader reader = loader.getReader(templateSource, null);
        String text = FileCopyUtils.copyToString((Reader)reader);
        ClassPathStoreTest.assertEquals((String)"<html></html>", (String)text);
    }

    @Test
    public void testScriptLoader() throws Exception {
        ScriptLoader loader = this.getClassPathStore().getScriptLoader();
        ScriptContent script = loader.getScript("folder2/script.js");
        ClassPathStoreTest.assertNotNull((Object)script);
        Reader reader = script.getReader();
        String text = FileCopyUtils.copyToString((Reader)reader);
        ClassPathStoreTest.assertEquals((String)"var test = 1;", (String)text);
    }
}

